%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%%  SSLサイトよりコンテンツを取得する
%%
%% ---------------------------------------------------------
%%  [使用述語]
%%  ssl_client_connect,ssl_socket_send,ssl_socket_receive
%%  ssl_socket_close
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:-dlib_require(socket_ssl).
test:-
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  サーバーにSSL接続する                        %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%%Host='www.verisign.co.jp',
	%%%host2ip(Host,GH,AH,IP),
	IP='127.0.0.1',
	ssl_client_connect(IP,'443','RSA',Sock),

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  サーバーにデータを送信する                   %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	name(C,[10]),
	D1 = 'GET /ssl_test.html HTTP/1.1',
	atom_concat(D1,C,D2),
	atom_concat(D2,'Host: ',D3),
	atom_concat(D3,IP,D4),
	atom_concat(D4,C,D5),
	atom_concat(D5,'Connection: Close',D6),
	atom_concat(D6,C,D7),
	atom_concat(D7,C,Data),
	ssl_socket_send(Sock,Data),

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  サーバーよりデータを受信する                 %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	get_all(Sock,"",LAns),
	name(Ans,LAns),
	write(Ans),nl,
	ssl_socket_close(Sock).

get_all(Sock2,Bef,Ans):-
	ssl_socket_receive(Sock2,Out),name(Out,OutL),length(OutL,N),N>0,!,
	append(Bef,OutL,NextBef),
	get_all(Sock2,NextBef,Ans).
get_all(Sock2,A,A).

