%%%%%%%%%%%% Manual Display To Browser %%%%%%%%%%%%%%%%%%%%%
:- public manual/0.
:- public manual/1.
:- extern det:atom_appends/2.

%%%%
manual:- manual_disp('','index.html').

%%%%
manual(Pred):- var(Pred),!,error(9).
manual(Pred):- 
	manual_predicate(Pred),!,manual_disp('reference/jutugo.html#',Pred).

manual(Pred):- 
	member(Pred=Tag,     
	 [debugger = 'debugging.html',              % chap 6
	  compiler = 'compiler.html',               % chap 7
	  c_lang   = 'interface.html',              % chap 8
	  clp      = 'clp.html',                    % expand 1
	  parallel = 'parallelprocessing.html',     % expand 2
	  cgi      = 'cgi.html',                    % expand 3
	  oniguruma= 'oniguruma.html',              % expand 4
	  mecab    = 'mecab-cabocha.html',          % expand 5
	  socket   = 'socket.html',                 % expand 6
	  redis    = 'redis.html',                  % expand 7
	  odbc     = 'odbc.html',                   % expand 8
	  ole      = 'ole.html',                    % expand 9
	  azedit   = 'azedit.html',                 % expand 10
	  other    = 'function-1.html',             % expand 11
	  errmsg   = 'appendix.html#errmsg',        % appendix
	  console  = 'appendix.html#console'        % appendix
	  ]),!,
	manual_disp('manuals/manual_',Tag).
%%%
manual_disp(D,F):-
	get_install_base_dir_normalized(Env),
	manual_com(Env,D,F,List),atom_appends(List,Comd),system(Comd),d_redisp.
%%%
manual_predicate(Funct/A):- functor(Pred,Funct,A),!,s_sort(Pred,builtin).
manual_predicate(Pred):- get_builtin(Pred,_,_),!.
manual_predicate(Funct):- 
	member(A,[0,1,2,3,4,5,6]),functor(Pred,Funct,A),s_sort(Pred,builtin),!.
%%%
manual_com(Env,D,F,['xdg-open file://',Env,'/share/doc/azprolog/',D,F,' &']):-
	s_version(_,'LINUX',_,_),!.
manual_com(Env,D,F,['""C:\Program Files\Internet Explorer\iexplore.exe" "file://',Env,'/doc/',D,F,'""']).

