#ifndef	H_AZPROLOG_H
#define	H_AZPROLOG_H
/*  AZPROLOG.H Version 2.0 Compile Code/C Code Header File 1990 8 6 */
/*  AZPROLOG.H Version 6.0 Compile Code/C Code Header File 2009 11 18 */
/*  AZPROLOG.H Version 7.0 Compile Code/C Code Header File 2011 12 08 */

#define AZ_POINTER_SIZE   64

#include <setjmp.h>

#if     defined(__GNUC__)
#define UNUSED_PARAM		__attribute__((__unused__))
#else
#define UNUSED_PARAM
#endif

#ifdef WIN32
#	define AZlongjmp(a,b)	longjmp((_JBTYPE *)a,b)
#	define AZsetjmp(a)	setjmp((_JBTYPE *)a)
#else
#	define AZlongjmp(a,b)	longjmp((struct __jmp_buf_tag *)a,b)
#	define AZsetjmp(a)	setjmp((struct __jmp_buf_tag *)a)
#endif

#define AZ_MAX_ATOM_LENGTH	(0xffff)
 
#if AZ_POINTER_SIZE == 64
typedef long long		SBASEINT;
typedef unsigned long long	BASEINT;
typedef unsigned short		F_BASECHAR;
typedef unsigned int		F_BASESHORT;
#else 
typedef int			SBASEINT;
typedef unsigned int		BASEINT;
typedef unsigned char		F_BASECHAR;
typedef unsigned short		F_BASESHORT;
#endif

typedef int			BASEBOOL;
typedef unsigned char		BASECHAR;
typedef unsigned short		BASESHORT;

typedef void			*(*(*pred)())();

#ifndef	lint
#	define	DET_SUCC	((pred)(BASEINT)1)
#endif

#ifndef lint
#	define	INTERNAL	static
#	define	YIELD(r)	return (pred)((BASEINT)(r))
#	define	CUT_RETURN(p,v)	AZlongjmp(BODY(p), v)
#	define	NULLFRAME	((Frame*)0)
#endif

#define FAIL			((pred)0)
#define ATOM_NIL		(1L)

#define AZ_ENC_SJIS		(0)
#define AZ_ENC_EUCJP		(1)
#define AZ_ENC_UTF8		(2)


#ifndef AZ_BIG_ENDIAN
struct _TPAIR {F_BASECHAR d, v;};
#else
struct _TPAIR {F_BASECHAR v, d;};
#endif

typedef struct _TERM {
	union {struct _TERM *p; BASEINT i;}	b;
#ifndef AZ_BIG_ENDIAN
	union {F_BASESHORT e; struct _TPAIR s;}	t;
	F_BASESHORT	n;
#else
	F_BASESHORT	n;
	union {F_BASESHORT e; struct _TPAIR s;}	t;
#endif
} TERM;

typedef struct _UTERM {
	BASEINT		body;
	F_BASESHORT	no;
	F_BASESHORT	tag;
} UTERM;

#define SET_CLP(term)		((term)->t.s.d = clp_tag);	\
				((term)->t.s.v = 2)

#define TAG(term)		((term)->t.s.d + 0)
#define SETTAG(term, tag)	((term)->t.e = tag)
#define SETTAG_C(term, tag)	((term)->t.s.d = tag)
#define GVCLEAR(term)		((term)->t.e = undef_tag)
#define NO(term)		((term)->n)
#define BODY(term)		((term)->b.p)
#define INT_BODY(term)		((term)->b.i)

#define	DSHIFT			(2)
#define link_tag		(0 << DSHIFT)
#define undef_tag		(1 << DSHIFT)
#define int_tag			(2 << DSHIFT)
#define float_tag		(3 << DSHIFT)
#define atom_tag		(4 << DSHIFT)
#define term_tag		(5 << DSHIFT)
#define list_tag		(6 << DSHIFT)
#define gterm_tag		(7 << DSHIFT)
#define glist_tag		(8 << DSHIFT)
#define fh_tag			(9 << DSHIFT)
#define array_tag		(10 << DSHIFT)
#define lvar_tag		(11 << DSHIFT)
#define clp_tag			(12 << DSHIFT)
#define var_tag			(13 << DSHIFT)


#define REALVALUE(item)	\
	while (IS_LINK(item))	\
		 item = BODY(item)

#define IS_INT(term)		(TAG(term) == int_tag)
#define IS_ATOM(term)		(TAG(term) == atom_tag)
#define IS_FLOAT(term)		(TAG(term) == float_tag)
#define IS_LIST(term)		(IS_LIST0(term) || IS_GLIST(term))
#define IS_TERM(term)		(IS_TERM0(term) || IS_GTERM(term))
#define	IS_ARRAY(term)		(TAG(term) == array_tag)
#define	IS_HARRAY(term)		(TAG(term) == heap_array_tag)
#define	IS_FH(term)		(TAG(term) == fh_tag)

#define IS_CLPV(term)		((term)->t.s.v == 2)
#define IS_CLP(term)		(TAG(term) == clp_tag)
#define IS_UNDEF0(term)		(TAG(term) == undef_tag)
#define IS_UNDEF(term)		(TAG(term) == undef_tag || IS_CLP(term))
#define	IS_VAR(term)		(TAG(term) == var_tag)
#define	IS_TERM0(term)		(TAG(term) == term_tag)
#define	IS_LIST0(term)		(TAG(term) == list_tag)
#define	IS_GTERM(term)		(TAG(term) == gterm_tag)
#define	IS_GLIST(term)		(TAG(term) == glist_tag)
#define	IS_LINK(term)		(TAG(term) == link_tag)
#define	IS_CALLFRAME(term)	(TAG(term) == callframe_tag)
#define	IS_TOPLEVEL(term)	(TAG(term) == toplevel_tag)
#define	IS_GFRAME(term)		(TAG(term) == gframe_tag)
#define	IS_TRAILMARK(term)	(TAG(term) == trailmark_tag)
#define	IS_NEURON(term)		(TAG(term) == heap_neuron_tag)
#define	IS_CLAUSE(term)		(TAG(term) == clause_tag)
#define	IS_CONTROL(term)	(TAG(term) == control_tag)
#define	IS_HGOALS(term)		(TAG(term) == hgoals_tag)

#define	HP_LT(a,b)		((a)< (b))
#define	HP_LE(a,b)		((a)<=(b))
#define	HP_GT(a,b)		((a)> (b))
#define	HP_GE(a,b)		((a)>=(b))
#define	HP_EQ(a,b)		((a)==(b))
#define	HP_NE(a,b)		((a)!=(b))

typedef struct _Frame
{
	struct _Frame	*Link;
	pred		(*Cont)();
	struct _Frame	*Env;
	TERM		*Local;
	TERM		*Global;
	TERM		**Trail;
	int		nVars;
	BASESHORT	ip;
	BASESHORT	cont_ip;
	TERM		*Bdefine;
} Frame;

#ifndef  lint

typedef struct INDEX_TABLE {
	BASEINT	atom;
	BASEINT	arity; 
	BASEINT	casev;
}	*IndexPtr;

#define IndexTable  struct INDEX_TABLE


typedef struct _BBLTN {
	char	*name;
	BASEINT	atomNo;
	int	arity;
	pred	(*proc)();
	char	 *pred_name;
	char	 *pred_name2;
	BASEINT	 pred_atomNo;
	BASEINT	 pred_atomNo2;
	int	 pred_type;
} BBLTN;

#define CALL_PRED(prd, cont, env, now, rc)				\
	now.Cont = cont;	now.Env = env;				\
	rc = prd(&now);							\
	while (rc != FAIL) {						\
		if (rc == DET_SUCC) {					\
			next_var_cell = env->Local;			\
			if ((rc = (*now.Cont)(now.Env, &now)) == FAIL)	\
				break;					\
	  	}							\
		rc = (pred)(*rc)(&now);					\
	}

#define B1_CALL_PRED(my_function, cont, env, now, rc)   		\
	now.Cont = cont;	now.Env = env;				\
	rc = my_function;						\
	while (rc != FAIL) {						\
		if (rc == DET_SUCC) {					\
			next_var_cell = env->Local;			\
		 	if ((rc = (*now.Cont)(now.Env, &now)) == FAIL) 	\
				break;					\
		}							\
	  	rc = (pred)(*rc)(&now);					\
	}

#define CALL_PRED_DET(prd, cont, cont1,env, now, rc)			\
	now.Cont = cont;	now.Env = env;				\
	rc = prd(&now);							\
	while ( rc != DET_SUCC || now.Cont != cont1) {			\
		if (rc == DET_SUCC) {					\
			next_var_cell = env->Local;			\
			rc = (*now.Cont)(now.Env, &now);		\
		}							\
		if(rc == FAIL) YIELD(FAIL);				\
		rc = (pred)(*rc)(&now);					\
	}

#define B1_CALL_PRED_DET(my_function, cont, cont1,env, now, rc)		\
	now.Cont = cont;	now.Env = env;				\
	rc = my_function;						\
	while ( rc != DET_SUCC || now.Cont != cont1) {	  		\
		if (rc == DET_SUCC) {					\
			next_var_cell = env->Local;			\
			rc = (*now.Cont)(now.Env, &now);		\
		}							\
		if(rc == FAIL) YIELD(FAIL);				\
		rc = (pred)(*rc)(&now);					\
	}

#define CALL_PRED_FF(prd, cont, env, now, rc)		   		\
	now.Cont = cont;	now.Env = env;			  	\
	if ((rc = prd(&now)) == FAIL)				   	\
		YIELD(FAIL);						\
	while (rc != DET_SUCC){						\
		if ((rc  = (pred)(*rc)(&now)) == FAIL)  		\
			YIELD(FAIL);					\
	}

#define B1_CALL_PRED_FF(my_function, cont, env, now, rc)  		\
	now.Cont = cont;	now.Env = env;				\
	if ((rc = my_function) == FAIL)					\
		YIELD(FAIL);						\
	while (rc != DET_SUCC){						\
		if ((rc  = (pred)(*rc)(&now)) == FAIL)		 	\
			YIELD(FAIL);					\
	}

#define B1_CALL_PRED_FF2(my_function,now,rc)  				\
	if ((rc = my_function) == FAIL)					\
		YIELD(FAIL);						\
	while (rc != DET_SUCC){						\
		if ((rc  = (pred)(*rc)(&now)) == FAIL)		 	\
			YIELD(FAIL);					\
	}


#define CALL_CDET(prd, env, rc, fail_label)				\
	rc = prd(env);							\
	while (rc != FAIL && rc != DET_SUCC){		   		\
		rc  = (pred)(*rc)(env);				 	\
	}								\
	if( rc == FAIL ) fail_label

#define CALL_LASTGOAL(prd, env, now, rc)				\
	now.cont_ip = env->cont_ip;					\
	now.Cont = env->Cont;	now.Env = env->Env;			\
	rc = prd(&now);							\
	while (rc != FAIL) {						\
		if (rc == DET_SUCC) {					\
			next_var_cell = env->Local;			\
		 	if ((rc = (*now.Cont)(now.Env, &now)) == FAIL)	\
				break;					\
	  	}							\
		rc = (pred)(*rc)(&now);					\
	}

#define B1_CALL_LASTGOAL(my_function, env, now, rc)			\
	now.cont_ip = env->cont_ip;	  				\
	now.Cont = env->Cont;	now.Env = env->Env;			\
	rc = my_function;						\
	while (rc != FAIL) {						\
		if (rc == DET_SUCC) {					\
			next_var_cell = env->Local;			\
		 	if ((rc = (*now.Cont)(now.Env, &now)) == FAIL) 	\
				break;					\
	  	}							\
	  	rc = (pred)(*rc)(&now);					\
	}

#define CALL_CONT(env, now, rc)						\
	now.cont_ip = env->cont_ip;	   				\
	rc = (*env->Cont)(env->Env, &now);				\
	while (rc != FAIL) {						\
		rc = (pred)(*rc)(&now);					\
		if (rc == DET_SUCC) {					\
			next_var_cell = env->Local;			\
			rc = (*now.Cont)(now.Env, &now);		\
		}							\
	}

#endif

/* Set Environment Frame */ 
#define LINK0(fp)							\
	if (HP_GE(next_var_cell, var_bottom))				\
		LocalOverflow();					\
	fp->Local = next_var_cell

#define LINK1(fp, vmax, vars)						\
	if (HP_GE(next_gvar_cell + vmax, gvar_bottom))			\
		MakeRoom(fp, vmax);					\
	fp->Global = next_gvar_cell;					\
	fp->Trail = trail_register;					\
	frozen_goal_register = (TERM *)0;				\
	next_gvar_cell += (fp->nVars = vars)

#define LINK1Z(fp, vmax)						\
	if (HP_GE(next_gvar_cell + vmax, gvar_bottom))			\
		MakeRoom(fp, vmax);					\
	fp->Global = next_gvar_cell;					\
	fp->Trail = trail_register;					\
	frozen_goal_register = (TERM *)0;				\
	fp->nVars = 0

#define LINK1ZZ(fp)							\
	fp->Global = next_gvar_cell;					\
	fp->Trail = trail_register;					\
	frozen_goal_register = (TERM *)0;				\
	fp->nVars = 0

/* New Added */
#define LINK1NoCLP(fp, vmax, vars)					\
	if (HP_GE(next_gvar_cell + vmax, gvar_bottom))			\
		MakeRoom(fp, vmax);					\
	fp->Global = next_gvar_cell;					\
	fp->Trail = trail_register;					\
	next_gvar_cell += (fp->nVars = vars)

#define LINK1ZNoCLP(fp, vmax)						\
	if (HP_GE(next_gvar_cell + vmax, gvar_bottom))			\
		MakeRoom(fp, vmax);					\
	fp->Global = next_gvar_cell;					\
	fp->Trail = trail_register;					\
	fp->nVars = 0

#define LINK1ZZNoCLP(fp)						\
	fp->Global = next_gvar_cell;					\
	fp->Trail = trail_register;					\
	fp->nVars = 0

#define RELINK0NoCLP(fp)						\
	{ TERM *w;							\
	while (HP_GT(trail_register, fp->Trail)){			\
	     w=*(--trail_register);					\
	     if(w->t.s.v==2) w->t.s.d=clp_tag; else w->t.s.d=undef_tag;} \
	next_var_cell = fp->Local; }

#define RELINK0(fp)							\
	{ TERM *w;							\
	while (HP_GT(trail_register, fp->Trail)){			\
	     w=*(--trail_register);					\
	     if(w->t.s.v==2) w->t.s.d=clp_tag; else w->t.s.d=undef_tag;} \
	frozen_goal_register = (TERM *)0;				\
	next_var_cell = fp->Local; }

#define RESET_GLOBAL(fp,vars)						\
	next_gvar_cell = fp->Global + (fp->nVars = vars)

#define INDX_GOTO(Call_by_value,Call_by_var) \
{ if(value_or_var) Call_by_value; else Call_by_var; }

#define SWITCH_ON_LIST_NIL_VAR(CheckTerm,IFlist,IFnil,IFvar,Other)	\
{  TERM *a=CheckTerm;					 	\
   Switch_Head:								\
   switch(TAG(a)){							\
	case link_tag:  a=BODY(a); goto Switch_Head;			\
	case undef_tag: IFvar;						\
	case atom_tag:  if(INT_BODY(a) == ATOM_NIL ) IFnil; else Other; \
	case list_tag:							\
	case glist_tag: IFlist;						\
	default:	Other; } }
	  

#define RELINKNoCLP(fp, vars)                                           \
        { TERM *w;                                                      \
	while (HP_GT(trail_register, fp->Trail)){			\
	     w=*(--trail_register);					\
             if(w->t.s.v==2) w->t.s.d=clp_tag; else w->t.s.d=undef_tag;} \
        next_var_cell = fp->Local;                                      \
        next_gvar_cell = fp->Global + (fp->nVars = vars); }

#define RELINK(fp,vars)                                                 \
        { TERM *w;                                                      \
        while (HP_GT(trail_register, fp->Trail)){                       \
             w=*(--trail_register);                                     \
             if(w->t.s.v==2) w->t.s.d=clp_tag; else w->t.s.d=undef_tag;} \
        frozen_goal_register = (TERM *)0;                               \
        next_var_cell = fp->Local;                                      \
        next_gvar_cell = fp->Global + (fp->nVars = vars); }

#define RELINKZNoCLP(fp,vars)						\
	{ TERM *w;							\
	while (HP_GT(trail_register, fp->Trail)){			\
	     w=*(--trail_register);					\
	     if(w->t.s.v==2) w->t.s.d=clp_tag; else w->t.s.d=undef_tag;} \
	next_var_cell = fp->Local;					\
	next_gvar_cell = fp->Global + (fp->nVars = vars); }

#define RELINKZ(fp)						\
	{ TERM *w;							\
	while (HP_GT(trail_register, fp->Trail)){			\
	     w=*(--trail_register);					\
	     if(w->t.s.v==2) w->t.s.d=clp_tag; else w->t.s.d=undef_tag;} \
	next_var_cell = fp->Local;					\
	next_gvar_cell = fp->Global;					\
	frozen_goal_register = (TERM *)0;				\
	fp->nVars = 0; }

#define PUTVAL(item, place)						\
	if (IS_UNDEF(item)) {		\
		SETTAG(place, link_tag);				\
		BODY(place) = item;					\
	} else								\
		((place)->b.p = (item)->b.p, (place)->t.s.d = (item)->t.s.d, (place)->n = (item)->n)

#define PUTVARC(item, place)						\
	SETTAG(item,undef_tag);						\
	SETTAG(place, link_tag);					\
	BODY(place) = item

#define PUTVAR(item, place)						\
	SETTAG(place, link_tag);					\
	BODY(place) = item

#define PUTVAR_C(item, place)						\
	SETTAG_C(place, link_tag);					\
	BODY(place) = item

#define PUTARG(src, dst)						\
	((dst)->b.p = (src)->b.p, (dst)->t.s.d = (src)->t.s.d, (dst)->n = (src)->n)

#define GETGLOBAL(fp, lhv, n)						\
	lhv = next_gvar_cell;						\
	if (HP_GE(next_gvar_cell += n, gvar_bottom))			\
		lhv = MakeRoom1(fp, n)

#define CHKLOCAL(cells)							\
	if (HP_GE(next_var_cell + cells, var_bottom))			\
		LocalOverflow();

#define PUSH_STACK(pt)	if(HP_GE(pt,gvar_top) && HP_LT(pt,gvar_bottom)){  \
				SETTAG(next_var_cell, link_tag);	  \
			} else SETTAG(next_var_cell, int_tag);		  \
			BODY(next_var_cell++) = pt
				
#define POP_STACK(pt)	pt = BODY(--next_var_cell)

#define GETGLOBAL_ARG1(fp, lhv, n, arg)                 \
        lhv = next_gvar_cell;                           \
        if (HP_GE(next_gvar_cell += n, gvar_bottom)){   \
		CHKLOCAL(1);				\
                PUSH_STACK(arg);                        \
                lhv = MakeRoom1(fp, n) ;                \
                POP_STACK(arg); }

#define GETGLOBAL_ARG2(fp, lhv, n, arg1,arg2)           \
        lhv = next_gvar_cell;                           \
        if (HP_GE(next_gvar_cell += n, gvar_bottom)){   \
		CHKLOCAL(2);				\
                PUSH_STACK(arg1);                       \
                PUSH_STACK(arg2);                       \
                lhv = MakeRoom1(fp, n) ;                \
                POP_STACK(arg2);			\
                POP_STACK(arg1); }

#define GETGLOBAL_ARG3(fp, lhv, n, arg1,arg2,arg3)      \
        lhv = next_gvar_cell;                           \
        if (HP_GE(next_gvar_cell += n, gvar_bottom)){   \
		CHKLOCAL(3);				\
                PUSH_STACK(arg1);                       \
                PUSH_STACK(arg2);                       \
                PUSH_STACK(arg3);                       \
                lhv = MakeRoom1(fp, n) ;                \
                POP_STACK(arg3);			\
                POP_STACK(arg2);			\
                POP_STACK(arg1); }

#define PUTNIL(s)	SETTAG(s, atom_tag);		\
			INT_BODY(s) = ATOM_NIL


#define PUTINT(i,s)	SETTAG(s, int_tag);		\
			INT_BODY(s) = (BASEINT)i

#define PUTATOM(i,s)	SETTAG(s, atom_tag);	   	\
			INT_BODY(s) = (BASEINT)(i)

#define PUTGROUND(i,s)  *(s) = *(TERM *)(i)

#define PUTVALD(s, d)					\
	if (IS_UNDEF0(s)) {				\
		SETTAG(d, link_tag);			\
		BODY(d) = (s);				\
	} else {					\
		*(d) = *(s);				\
	}						\
	(s) = (d)

#define PUTRVALD(a, d)						\
	for (; ; ) {						\
		switch (TAG(a)) {				\
		case undef_tag: SETTAG(d, link_tag);	  	\
				BODY(d) = (a);			\
				break;				\
		case link_tag:	(a) = BODY(a);		   	\
				continue;			\
		case float_tag:	SETTAG((d), float_tag); 	\
				BODY(d) = (d) + 1;		\
				*((d) + 1) = *BODY(a);		\
				*((d) + 2) = *(BODY(a) + 1);	\
				break;				\
		default:	*(d) = *(a);			\
				break;				\
		}						\
		break;						\
	}							\
	(a) = (d)


#define BytePredDefine(name,add)		\
	pred name(Env)				\
	Frame *Env;				\
	{ Env->ip=add; Env->Bdefine=(TERM *)user_atom; return bytecall(Env);}

#define AZ_ERROR(n)	yield_error_withinfo(n, &errinfo, &save_info)

struct WKSIZE {
	BASEINT a, c, ar, h, l, g, t;
};

#define	ERRINFO_LENGTH	(64*1024)

typedef struct _ERRINFO {
	char *fname;
	int line;
	int errcode;
	int read_error_code;
	char info[ERRINFO_LENGTH];
} ERRINFO;

#ifdef	DLL
#ifdef	MAKEDLL
#define	AZ_PUBLIC	__declspec(dllexport)
#define	AZ_EXTERN	AZ_PUBLIC
#else
#define	AZ_PUBLIC
#define	AZ_EXTERN	extern  __declspec(dllimport)
#endif
#else
#define	AZ_EXTERN	extern
#define	AZ_PUBLIC
#endif

AZ_EXTERN struct _BBLTN *built_table;
AZ_EXTERN struct _TERM	*gvar_bottom, *var_bottom;
AZ_EXTERN struct _TERM	*next_gvar_cell, *next_var_cell;
AZ_EXTERN struct _TERM	**trail_register;
AZ_EXTERN struct WKSIZE	wksize;
AZ_EXTERN struct _ERRINFO	errinfo;
AZ_EXTERN struct _ERRINFO	save_info;

AZ_EXTERN struct _TERM	*frozen_goal_register;
AZ_EXTERN struct _TERM	*frozen_goal_tail;

#ifndef	DLL
#define	SET_WKSIZE	struct WKSIZE wksize 
#else
#define	SET_WKSIZE	void init_wksize(void) { extern struct WKSIZE _wksize; wksize = *(struct WKSIZE*)&_wksize;} \
			struct WKSIZE _wksize
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* function prototype */
/* arity */
AZ_PUBLIC pred	P2_current_pred(Frame*);
AZ_PUBLIC pred	P2_clause(Frame*);
AZ_PUBLIC pred	P1_retract(Frame*);
AZ_PUBLIC pred	P1_nospy(Frame*);
AZ_PUBLIC pred	P1_spy(Frame*);
AZ_PUBLIC pred	P0_listing(Frame*);
AZ_PUBLIC pred	P1_listing(Frame*);
AZ_PUBLIC pred	P0_s_new(Frame*);
AZ_PUBLIC pred	P2_abolish(Frame*);
AZ_PUBLIC pred	P2_s_mode(Frame*);
AZ_PUBLIC pred	P3_retract(Frame*);
AZ_PUBLIC pred	P3_clause(Frame*);
AZ_PUBLIC pred	P4_clause(Frame*v);
AZ_PUBLIC pred	P2_s_sort(Frame*);
AZ_PUBLIC pred	P3_get_call_count(Frame*);
AZ_PUBLIC pred	P0_reset_call_count(Frame*);
AZ_PUBLIC pred	P1_reset_call_count(Frame*);
AZ_PUBLIC pred	P2_reset_call_count(Frame*);

AZ_PUBLIC void	put_bltn(char*, int, pred func());
AZ_PUBLIC int	spy(BASEINT, int, int, int, int, int);
AZ_PUBLIC int	B2_s_mode(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B3_clause(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B4_clause(Frame*, TERM*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B2_s_sort(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B3_retract(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B1_nospy(Frame*, TERM*);
AZ_PUBLIC int	B1_spy(Frame*, TERM*);
AZ_PUBLIC int	B1_listing(Frame*, TERM*);
AZ_PUBLIC int	B2_abolish(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B3_get_call_count(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B1_reset_call_count(Frame*, TERM*);
AZ_PUBLIC int	B2_reset_call_count(Frame*, TERM*, TERM*);

/* assert */
AZ_PUBLIC pred	P1_assert(Frame*);
AZ_PUBLIC pred	P1_assertz(Frame*);
AZ_PUBLIC pred	P2_assert(Frame*);
AZ_PUBLIC pred	P1_asserta(Frame*);
AZ_PUBLIC int	B1_assert(Frame*, TERM*);
AZ_PUBLIC int	B1_assertz(Frame*, TERM*);
AZ_PUBLIC int	B1_asserta(Frame*, TERM*);
AZ_PUBLIC int	B2_assert(Frame*, TERM*, TERM*);

/* atomman */
AZ_PUBLIC pred	P1_current_atom(Frame*);
AZ_PUBLIC pred	P3_current_op(Frame*);
AZ_PUBLIC pred	P3_op(Frame*);
AZ_PUBLIC pred	P2_atom(Frame*);
AZ_PUBLIC pred	P2_s_atom(Frame*);
AZ_PUBLIC pred	P2_prompt(Frame*);
AZ_PUBLIC pred	P2_name(Frame*);
AZ_PUBLIC pred	P3_atom_append(Frame*);
AZ_PUBLIC pred	P2_term_atom(Frame*);
AZ_PUBLIC BASEINT	PutAtom(Frame*, char*);
AZ_PUBLIC void	PutOperator(Frame*, BASESHORT, BASESHORT, char*);
AZ_PUBLIC pred	P2_set_prompt_detecting_postfix(Frame*);

AZ_PUBLIC int	B3_op(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B2_atom(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_s_atom(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_prompt(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_name(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B3_atom_append(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B2_term_atom(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_set_prompt_detecting_postfix(Frame*, TERM*, TERM*);

AZ_PUBLIC int	az_get_atom_length(BASEINT);
AZ_PUBLIC int	az_get_atom_term_length(Frame*, TERM*);

/* azpi */
AZ_PUBLIC pred	P1_call(Frame*);
AZ_PUBLIC pred	P1_leash(Frame*);
AZ_PUBLIC pred	P1_leash1(Frame*);
AZ_PUBLIC pred	P1_leash2(Frame*);
AZ_PUBLIC pred	P1_leash3(Frame*);
AZ_PUBLIC pred	call(Frame*);
AZ_PUBLIC pred	dCall(Frame*);
AZ_PUBLIC pred	nComma(Frame*);
AZ_PUBLIC pred	dComma(Frame*);
AZ_PUBLIC pred	nSemi(Frame*);
AZ_PUBLIC pred	dSemi(Frame*);
AZ_PUBLIC pred	P0_debug(Frame*);
AZ_PUBLIC pred	P0_trace(Frame*);
AZ_PUBLIC pred	P0_notrace(Frame*);
AZ_PUBLIC pred	P0_nodebug(Frame*);
AZ_PUBLIC pred	P0_debugging(Frame*);
AZ_PUBLIC int	B1_leash(Frame*, TERM*);
AZ_PUBLIC int	B1_leash1(Frame*, TERM*);
AZ_PUBLIC int	B1_leash2(Frame*, TERM*);
AZ_PUBLIC int	B1_leash3(Frame*, TERM*);
AZ_PUBLIC void	yield_error_withinfo(int, struct _ERRINFO*, struct _ERRINFO*);

/* azpi/caller */
AZ_PUBLIC pred	comma(Frame*);
AZ_PUBLIC pred	semi(Frame*);

/* bload */
AZ_PUBLIC pred	P1_b_load(Frame*);
AZ_PUBLIC pred	P9_b_load(Frame*);

/* builtin */
AZ_PUBLIC void	builtin_all(void);
AZ_PUBLIC void	user_file(void);

/* bytecall */
AZ_PUBLIC pred	bytecall(Frame*);
AZ_PUBLIC void	byte_set_user_heap(UTERM*, UTERM*, UTERM*, int);
AZ_PUBLIC void	byte_set_user_atom(UTERM*, int);
AZ_PUBLIC pred	P3_sort_byte_index(Frame*);
AZ_PUBLIC pred	P3_sort_byte_index2(Frame*);
AZ_PUBLIC pred	P6_set_byte_module(Frame*);
AZ_PUBLIC pred	P3_set_byte_heap(Frame*);
AZ_PUBLIC pred	P_bytecall(Frame*);
AZ_PUBLIC void	init_copy_byte_set_user_atom(UTERM [], UTERM [], int);
AZ_PUBLIC void	init_copy_byte_set_user_heap(UTERM [], UTERM [], int);

/* caller */
AZ_PUBLIC pred	B1_call(Frame*, BASEINT, int, TERM*, ...);

/* compare */
AZ_PUBLIC pred	eqterm(Frame*);
AZ_PUBLIC pred	noteqterm(Frame*);
AZ_PUBLIC pred	gtterm(Frame*);
AZ_PUBLIC pred	geterm(Frame*);
AZ_PUBLIC pred	ltterm(Frame*);
AZ_PUBLIC pred	leterm(Frame*);
AZ_PUBLIC pred	P3_compare(Frame*);
AZ_PUBLIC pred	P0_sh(Frame*);
AZ_PUBLIC pred	P1_chdir(Frame*);
AZ_PUBLIC pred	P1_system(Frame*);
AZ_PUBLIC pred	P2_system(Frame*);
AZ_PUBLIC pred	P2_getenv(Frame*);
AZ_PUBLIC pred	P1_random_seed(Frame*);
AZ_PUBLIC pred	P2_s_random(Frame*);
AZ_PUBLIC pred	P2_s_randomize(Frame*);
AZ_PUBLIC pred	P2_system(Frame*);

AZ_PUBLIC int	B_gtterm(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B_geterm(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B3_compare(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B1_chdir(Frame*, TERM*);
AZ_PUBLIC int	B1_system(Frame*, TERM*);
AZ_PUBLIC int	B2_system(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_getenv(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_random_seed(Frame*, TERM*);
AZ_PUBLIC int	B2_s_random(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_s_randomize(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B_eqterm(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B_noteqterm(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B_ltterm(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B_leterm(Frame*, TERM*, TERM*);

/* compute2 */
AZ_PUBLIC int	s_add(Frame*, TERM*, int, ...);
AZ_PUBLIC int	s_mlt(Frame*, TERM*, int, ...);
AZ_PUBLIC int	s_sub(Frame*, TERM*, int, ...);
AZ_PUBLIC int	s_div(Frame*, TERM*, int, ...);
AZ_PUBLIC int	s_sub_eval_eq(TERM*, int, ...);
AZ_PUBLIC int	s_sub_eval_noteq(TERM*, int, ...);
AZ_PUBLIC int	s_add_eval_eq(TERM*, int, ...);
AZ_PUBLIC int	s_add_eval_noteq(TERM*, int, ...);
AZ_PUBLIC int	s_calc_eval_comp(TERM*, int, int, int, ...);
AZ_PUBLIC int	s_add1(Frame*, TERM*, TERM*, BASEINT);
AZ_PUBLIC int	s_mlt1(Frame*, TERM*, TERM*, BASEINT);
AZ_PUBLIC int	s_sub1(Frame*, TERM*, TERM*, BASEINT);
AZ_PUBLIC int	s_sub2(Frame*, TERM*, BASEINT, TERM*);
AZ_PUBLIC int	s_div1(Frame*, TERM*, TERM*, BASEINT);
AZ_PUBLIC int	s_div2(Frame*, TERM*, BASEINT, TERM*);
AZ_PUBLIC int	sc_ncomp(TERM*, BASEINT, int);
AZ_PUBLIC int	sfc_ncomp(TERM*, double, int);
AZ_PUBLIC int	s_dec(Frame*, TERM*, TERM*);
AZ_PUBLIC int	s_inc(Frame*, TERM*, TERM*);
AZ_PUBLIC int	s_left_shift(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	s_calc_by_typeE(Frame*, TERM*, TERM*, TERM*, int);
AZ_PUBLIC int	s_calc_int_by_typeE(Frame*, TERM*, TERM*, BASEINT, int);

#define	s_calc_by_type(a,b,c,d)		s_calc_by_typeE(Env,a,b,c,d)
#define	s_calc_int_by_type(a,b,c,d)	s_calc_int_by_typeE(Env,a,b,c,d)

/* curses/terminal */
AZ_PUBLIC pred	P0_d_clear(Frame*);
AZ_PUBLIC pred	P0_d_cleol(Frame*);
AZ_PUBLIC pred	P0_d_cleos(Frame*);
AZ_PUBLIC pred	P1_d_cursor(Frame*);
AZ_PUBLIC pred	P2_d_cursor(Frame*);
AZ_PUBLIC pred	P1_d_keyback(Frame*);
AZ_PUBLIC pred	P2_d_pos(Frame*);
AZ_PUBLIC pred	P2_d_screen(Frame*);
AZ_PUBLIC pred	P2_d_scroll(Frame*);
AZ_PUBLIC pred	P0_d_redisp(Frame*);
AZ_PUBLIC pred	P1_d_keyin(Frame*);
AZ_PUBLIC pred	P1_d_keylength(Frame*);
AZ_PUBLIC pred	P1_d_keypeek(Frame*);
AZ_PUBLIC int	B1_d_keyin(Frame*, TERM*);
AZ_PUBLIC int	B1_d_cursor(Frame*, TERM*);
AZ_PUBLIC int	B2_d_cursor(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_d_keyback(Frame*, TERM*);
AZ_PUBLIC int	B2_d_pos(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_d_screen(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_d_scroll(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_d_keylength(Frame*, TERM*);
AZ_PUBLIC int	B1_d_keypeek(Frame*, TERM*);

/* dbase */
AZ_PUBLIC pred	P1_d_open(Frame*);
AZ_PUBLIC pred	P1_d_close(Frame*);
AZ_PUBLIC pred	P1_d_opening(Frame*);
AZ_PUBLIC pred	P2_d_create(Frame*);
AZ_PUBLIC pred	P2_d_struct(Frame*);
AZ_PUBLIC pred	P4_d_record(Frame*);
AZ_PUBLIC pred	P3_d_seek(Frame*);
AZ_PUBLIC pred	P2_d_read(Frame*);
AZ_PUBLIC pred	P3_d_read(Frame*);
AZ_PUBLIC pred	P3_d_write(Frame*);
AZ_PUBLIC pred	P3_d_writeq(Frame*);
AZ_PUBLIC int	B1_d_open(Frame*, TERM*);
AZ_PUBLIC int	B1_d_close(Frame*, TERM*);
AZ_PUBLIC int	B1_d_opening(Frame*, TERM*);
AZ_PUBLIC int	B2_d_create(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_d_struct(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B4_d_record(Frame*, TERM*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_d_seek(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B2_d_read(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B3_d_read(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_d_write(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_d_writeq(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_d_write_1(Frame*, TERM*, TERM*, TERM*, int);


/* edit */
AZ_PUBLIC pred	P0_e_edit(Frame*);
AZ_PUBLIC pred	P2_e_edit(Frame*);
AZ_PUBLIC pred	P0_e_init(Frame*);
AZ_PUBLIC pred	P1_e_init(Frame*);
AZ_PUBLIC pred	P2_e_init(Frame*);
AZ_PUBLIC pred	P1_e_dline(Frame*);
AZ_PUBLIC pred	P0_e_end(Frame*);
AZ_PUBLIC pred	P2_e_bell(Frame*);
AZ_PUBLIC pred	P0_e_refresh(Frame*);
AZ_PUBLIC pred	P1_e_forward(Frame*);
AZ_PUBLIC pred	P1_e_backward(Frame*);
AZ_PUBLIC pred	P0_e_echo(Frame*);
AZ_PUBLIC pred	P1_e_echo(Frame*);
AZ_PUBLIC pred	P1_e_alpha(Frame*);
AZ_PUBLIC pred	P1_e_digit(Frame*);
AZ_PUBLIC pred	P1_e_space(Frame*);
AZ_PUBLIC pred	P1_e_lower(Frame*);
AZ_PUBLIC pred	P2_e_lower(Frame*);
AZ_PUBLIC pred	P1_e_upper(Frame*);
AZ_PUBLIC pred	P2_e_upper(Frame*);
AZ_PUBLIC pred	P1_e_kanji(Frame*);
AZ_PUBLIC pred	P1_e_kanji1(Frame*);
AZ_PUBLIC pred	P1_e_kanji2(Frame*);
AZ_PUBLIC pred	P1_e_kana(Frame*);
AZ_PUBLIC pred	P1_e_insert(Frame*);
AZ_PUBLIC pred	P0_e_disp(Frame*);
AZ_PUBLIC pred	P1_e_pos(Frame*);
AZ_PUBLIC pred	P2_e_pos(Frame*);
AZ_PUBLIC pred	P1_e_repos(Frame*);
AZ_PUBLIC pred	P0_e_new(Frame*);
AZ_PUBLIC pred	P1_e_char(Frame*);
AZ_PUBLIC pred	P0_e_next(Frame*);
AZ_PUBLIC pred	P0_e_previous(Frame*);
AZ_PUBLIC pred	P0_e_bob(Frame*);
AZ_PUBLIC pred	P0_e_eob(Frame*);
AZ_PUBLIC pred	P1_e_eob(Frame*);
AZ_PUBLIC pred	P0_e_bol(Frame*);
AZ_PUBLIC pred	P0_e_eol(Frame*);
AZ_PUBLIC pred	P1_e_bol(Frame*);
AZ_PUBLIC pred	P1_e_eol(Frame*);
AZ_PUBLIC pred	P1_e_down(Frame*);
AZ_PUBLIC pred	P1_e_up(Frame*);
AZ_PUBLIC pred	P1_e_mark(Frame*);
AZ_PUBLIC pred	P0_e_mark(Frame*);
AZ_PUBLIC pred	P0_e_markend(Frame*);
AZ_PUBLIC pred	P1_e_jump(Frame*);
AZ_PUBLIC pred	P1_e_nword(Frame*);
AZ_PUBLIC pred	P1_e_pword(Frame*);
AZ_PUBLIC pred	P1_e_delete(Frame*);
AZ_PUBLIC pred	P1_e_kill(Frame*);
AZ_PUBLIC pred	P0_e_kill(Frame*);
AZ_PUBLIC pred	P0_e_yank(Frame*);
AZ_PUBLIC pred	P2_e_bothcase(Frame*);
AZ_PUBLIC pred	P1_e_fsearch(Frame*);
AZ_PUBLIC pred	P1_e_bsearch(Frame*);
AZ_PUBLIC pred	P2_e_change(Frame*);
AZ_PUBLIC pred	P1_e_create(Frame*);
AZ_PUBLIC pred	P0_e_free(Frame*);
AZ_PUBLIC pred	P1_e_getbs(Frame*);

AZ_PUBLIC int	B2_e_edit(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_e_init(Frame*, TERM*);
AZ_PUBLIC int	B2_e_init(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_e_dline(Frame*, TERM*);
AZ_PUBLIC int	B2_e_bell(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_e_forward(Frame*, TERM*);
AZ_PUBLIC int	B1_e_backward(Frame*, TERM*);
AZ_PUBLIC int	B1_e_echo(Frame*, TERM*);
AZ_PUBLIC int	B1_e_alpha(Frame*, TERM*);
AZ_PUBLIC int	B1_e_digit(Frame*, TERM*);
AZ_PUBLIC int	B1_e_space(Frame*, TERM*);
AZ_PUBLIC int	B1_e_lower(Frame*, TERM*);
AZ_PUBLIC int	B2_e_lower(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_e_upper(Frame*, TERM*);
AZ_PUBLIC int	B2_e_upper(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_e_kanji(Frame*, TERM*);
AZ_PUBLIC int	B1_e_kanji1(Frame*, TERM*);
AZ_PUBLIC int	B1_e_kanji2(Frame*, TERM*);
AZ_PUBLIC int	B1_e_kana(Frame*, TERM*);
AZ_PUBLIC int	B1_e_insert(Frame*, TERM*);
AZ_PUBLIC int	B1_e_pos(Frame*, TERM*);
AZ_PUBLIC int	B2_e_pos(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_e_repos(Frame*, TERM*);
AZ_PUBLIC int	B1_e_char(Frame*, TERM*);
AZ_PUBLIC int	B1_e_eob(Frame*, TERM*);
AZ_PUBLIC int	B1_e_bol(Frame*, TERM*);
AZ_PUBLIC int	B1_e_eol(Frame*, TERM*);
AZ_PUBLIC int	B1_e_down(Frame*, TERM*);
AZ_PUBLIC int	B1_e_up(Frame*, TERM*);
AZ_PUBLIC int	B1_e_mark(Frame*, TERM*);
AZ_PUBLIC int	B1_e_jump(Frame*, TERM*);
AZ_PUBLIC int	B1_e_nword(Frame*, TERM*);
AZ_PUBLIC int	B1_e_pword(Frame*, TERM*);
AZ_PUBLIC int	B1_e_delete(Frame*, TERM*);
AZ_PUBLIC int	B1_e_kill(Frame*, TERM*);
AZ_PUBLIC int	B2_e_bothcase(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_e_fsearch(Frame*, TERM*);
AZ_PUBLIC int	B1_e_bsearch(Frame*, TERM*);
AZ_PUBLIC int	B2_e_change(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_e_create(Frame*, TERM*);
AZ_PUBLIC int	B1_e_getbs(Frame*, TERM*);

/* etc */
AZ_PUBLIC pred	P0_halt(Frame*);
AZ_PUBLIC pred	P1_get_parameter(Frame*);
AZ_PUBLIC pred	P1_halt(Frame*);
AZ_PUBLIC pred	P2_errormode(Frame*);
AZ_PUBLIC pred	P2_s_verbos(Frame*);
AZ_PUBLIC pred	P0_statistics(Frame*);
AZ_PUBLIC pred	P4_s_version(Frame*);
AZ_PUBLIC pred	P3_s_divide_float(Frame*);
AZ_PUBLIC pred	P0_repeat(Frame*);
AZ_PUBLIC pred	P1_repeat(Frame*);
AZ_PUBLIC int	B1_halt(Frame*, TERM*);
AZ_PUBLIC int	B1_get_parameter(Frame*, TERM*);
AZ_PUBLIC int	B2_s_verbos(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B3_s_divide_float(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B2_errormode(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B4_s_version(Frame*, TERM*, TERM*, TERM*, TERM*);

/* eval */
AZ_PUBLIC pred	S2_catch(Frame*);
AZ_PUBLIC pred	S2_errorset(Frame*);
AZ_PUBLIC pred	P2_errorset(Frame*);
AZ_PUBLIC pred	P0_reset_statistics(Frame*);
AZ_PUBLIC pred	P2_catch(Frame*);
AZ_PUBLIC pred	arrow(Frame*);
AZ_PUBLIC pred	negate(Frame*);
AZ_PUBLIC pred	P0_true(Frame*);
AZ_PUBLIC pred	P0_fail(Frame*);
AZ_PUBLIC pred	P1_error(Frame*);
AZ_PUBLIC pred	P0_abort(Frame*);
AZ_PUBLIC pred	P1_throw(Frame*);
AZ_PUBLIC pred	P2_unknown(Frame*);
AZ_PUBLIC pred	P1_consult(Frame*);
AZ_PUBLIC pred	P1_reconsult(Frame*);
AZ_PUBLIC pred	P0_e_consult(Frame*);
AZ_PUBLIC pred	P0_e_reconsult(Frame*);
AZ_PUBLIC pred	cut(Frame*);
AZ_PUBLIC int	B_negate(Frame*,TERM*);
AZ_PUBLIC int	B1_error(Frame*, TERM*);
AZ_PUBLIC int	B1_throw(Frame*, TERM*);
AZ_PUBLIC int	B2_unknown(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_consult(Frame*, TERM*);
AZ_PUBLIC int	B1_reconsult(Frame*, TERM*);

/* file */
AZ_PUBLIC pred	P1_see(Frame*);
AZ_PUBLIC pred	P1_tell(Frame*);
AZ_PUBLIC pred	P1_tella(Frame*);
AZ_PUBLIC pred	P0_seen(Frame*);
AZ_PUBLIC pred	P0_told(Frame*);
AZ_PUBLIC pred	P0_fileerrors(Frame*);
AZ_PUBLIC pred	P0_nofileerrors(Frame*);
AZ_PUBLIC pred	P2_fileerrors(Frame*);
AZ_PUBLIC pred	P1_seeing(Frame*);
AZ_PUBLIC pred	P1_telling(Frame*);
AZ_PUBLIC pred	P0_nl(Frame*);
AZ_PUBLIC pred	P1_nl(Frame*);
AZ_PUBLIC pred	P0_ttynl(Frame*);
AZ_PUBLIC pred	P0_log(Frame*);
AZ_PUBLIC pred	P0_flush_log(Frame*);
AZ_PUBLIC pred	P0_nolog(Frame*);
AZ_PUBLIC pred	P1_log(Frame*);
AZ_PUBLIC pred	P1_logging(Frame*);
AZ_PUBLIC pred	P1_put(Frame*);
AZ_PUBLIC pred	P2_put(Frame*);
AZ_PUBLIC pred	P1_ttyput(Frame*);
AZ_PUBLIC pred	P1_get(Frame*);
AZ_PUBLIC pred	P2_get(Frame*);
AZ_PUBLIC pred	P1_get0(Frame*);
AZ_PUBLIC pred	P2_get0(Frame*);
AZ_PUBLIC pred	P1_get1(Frame*);
AZ_PUBLIC pred	P2_get1(Frame*);
AZ_PUBLIC pred	P1_ttyget(Frame*);
AZ_PUBLIC pred	P1_ttyget0(Frame*);
AZ_PUBLIC pred	P0_copy0(Frame*);
AZ_PUBLIC pred	P0_copy1(Frame*);
AZ_PUBLIC pred	P1_skip(Frame*);
AZ_PUBLIC pred	P1_ttyskip(Frame*);
AZ_PUBLIC pred	P1_tab(Frame*);
AZ_PUBLIC pred	P2_tab(Frame*);
AZ_PUBLIC pred	P2_see(Frame*);
AZ_PUBLIC pred	P2_tell(Frame*);
AZ_PUBLIC pred	P2_tella(Frame*);
AZ_PUBLIC pred	P1_seen(Frame*);
AZ_PUBLIC pred	P1_told(Frame*);
AZ_PUBLIC pred	P2_write(Frame*);
AZ_PUBLIC pred	P2_writeq(Frame*);
AZ_PUBLIC pred	P2_read(Frame*);
AZ_PUBLIC pred	P2_current_fp(Frame*);
AZ_PUBLIC pred	P2_seek(Frame*);
AZ_PUBLIC pred	P2_listing(Frame*);
AZ_PUBLIC pred	P2_rename(Frame*);
AZ_PUBLIC int	B1_see(Frame*, TERM*);
AZ_PUBLIC int	B1_tell(Frame*, TERM*);
AZ_PUBLIC int	B1_tella(Frame*, TERM*);
AZ_PUBLIC int	B2_fileerrors(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_seeing(Frame*, TERM*);
AZ_PUBLIC int	B1_telling(Frame*, TERM*);
AZ_PUBLIC int	B1_nl(Frame*, TERM*);
AZ_PUBLIC int	B1_log(Frame*, TERM*);
AZ_PUBLIC int	B1_logging(Frame*, TERM*);
AZ_PUBLIC int	B1_put(Frame*, TERM*);
AZ_PUBLIC int	B2_put(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_ttyput(Frame*, TERM*);
AZ_PUBLIC int	B1_get(Frame*, TERM*);
AZ_PUBLIC int	B2_get(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_get0(Frame*, TERM*);
AZ_PUBLIC int	B2_get0(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_get1(Frame*, TERM*);
AZ_PUBLIC int	B2_get1(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_ttyget(Frame*, TERM*);
AZ_PUBLIC int	B1_ttyget0(Frame*, TERM*);
AZ_PUBLIC int	B1_skip(Frame*, TERM*);
AZ_PUBLIC int	B1_ttyskip(Frame*, TERM*);
AZ_PUBLIC int	B1_tab(Frame*, TERM*);
AZ_PUBLIC int	B2_tab(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_see(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_tell(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_tella(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_seen(Frame*, TERM*);
AZ_PUBLIC int	B1_told(Frame*, TERM*);
AZ_PUBLIC int	B2_write(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_writeq(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_read(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_current_fp(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_seek(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_listing(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_rename(Frame*, TERM*, TERM*);

/* funccall */
AZ_PUBLIC pred	P5_s_child(Frame*);
AZ_PUBLIC pred	P3_s_wait(Frame*);
AZ_PUBLIC pred	P2_s_kill(Frame*);
AZ_PUBLIC pred	P1_s_sleep(Frame*);
AZ_PUBLIC pred	P1_s_usleep(Frame*);
AZ_PUBLIC pred	P1_s_pid(Frame*);
AZ_PUBLIC pred	P1_set_exit_timer(Frame*);
AZ_PUBLIC pred	P2_rm_builtin(Frame*);
AZ_PUBLIC pred	P0_s_flush(Frame*);
AZ_PUBLIC pred	P2_s_can_read(Frame*);
AZ_PUBLIC pred	P1_s_can_read(Frame*);
AZ_PUBLIC int	B1_s_pid(Frame*, TERM*);
AZ_PUBLIC int	B5_s_child(Frame*, TERM*, TERM*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_s_wait(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B2_s_kill(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_s_sleep(Frame*, TERM*);
AZ_PUBLIC int	B1_s_usleep(Frame*, TERM*);
AZ_PUBLIC int	B1_s_pid(Frame*, TERM*);
AZ_PUBLIC int	B1_set_exit_timer(Frame*, TERM*);
AZ_PUBLIC int	B2_rm_builtin(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B0_s_flush(Frame*);
AZ_PUBLIC int	B2_s_can_read(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_s_can_read(Frame*, TERM*);
AZ_PUBLIC int	B1_get_runtime(Frame*, TERM*);

/* ggc */
AZ_PUBLIC pred	P0_s_greclaim(Frame*);
AZ_PUBLIC void	MakeRoom(Frame*, int);
AZ_PUBLIC TERM	*MakeRoom1(Frame*, int);

/* hgc */
AZ_PUBLIC pred	P0_s_reclaim(Frame*);

/* iso_buil */
AZ_PUBLIC pred	P2_keysort(Frame*);
AZ_PUBLIC pred	P2_sort(Frame*);
AZ_PUBLIC pred	P3_append(Frame*);
AZ_PUBLIC pred	P2_member(Frame*);
AZ_PUBLIC pred	P1_retractall(Frame*);
AZ_PUBLIC pred	P1_ensure_loaded(Frame*);
AZ_PUBLIC pred	P2_statistics(Frame*);
AZ_PUBLIC pred	P1_get_runtime(Frame*);
AZ_PUBLIC pred	B1_retractall(Frame*, TERM*);
AZ_PUBLIC pred	B1_ensure_loaded(Frame*, TERM*);
AZ_PUBLIC pred	B2_statistics(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_get_runtime(Frame*, TERM*);
AZ_PUBLIC int	B2_keysort(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_sort(Frame*, TERM*, TERM*);

/* interf */
AZ_PUBLIC int	IsAtom(TERM*);
AZ_PUBLIC int	IsInt(TERM*);
AZ_PUBLIC int	IsDouble(TERM*);
AZ_PUBLIC int	IsUndef(TERM*);
AZ_PUBLIC int	IsCons(TERM*);
AZ_PUBLIC int	IsNil(TERM*);
AZ_PUBLIC int	IsCompTerm(TERM*);
AZ_PUBLIC BASEINT	GetAtom(TERM*);
AZ_PUBLIC BASEINT	GetInt(TERM*);
AZ_PUBLIC BASEINT	GetEvalInt(TERM*);
AZ_PUBLIC double	GetDouble(TERM*);
AZ_PUBLIC int	GetFunctor(TERM*, BASEINT*);
AZ_PUBLIC void	GetArg(TERM*, int);
AZ_PUBLIC void	GetCons(TERM*);

AZ_PUBLIC int	UnifyE(Frame*, TERM*, TERM*);
AZ_PUBLIC int	UnifyIntE(Frame*, TERM*, BASEINT);
AZ_PUBLIC int	UnifyAtomE(Frame*, TERM*, BASEINT);

#define	Unify(a,b)		UnifyE(Env,a,b)
#define	UnifyInt(a,b)		UnifyIntE(Env,a,b)
#define	UnifyAtom(a,b)		UnifyAtomE(Env,a,b)
#define	UnifyAtomEex(a,b)	unify_atomE_ex(Env,a,b)
#define	UnifyIntEex(a,b)	unify_intE_ex(Env,a,b)

AZ_PUBLIC int	UnifyDouble(Frame*, TERM*, double);
AZ_PUBLIC int	UnifyCompTerm(Frame*, TERM*, BASEINT, int, ...);
AZ_PUBLIC int	UnifyCons(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC void	MakeUndef(Frame*);
AZ_PUBLIC void	Atom2Asciz(BASEINT, char*);
AZ_PUBLIC BASEINT	Asciz2Atom(Frame*, char*);

/* kabapred */
AZ_PUBLIC pred	P4_g_screen(Frame*);
AZ_PUBLIC pred	P0_g_color(Frame*);
AZ_PUBLIC pred	P2_g_color(Frame*);
AZ_PUBLIC pred	P3_g_color(Frame*);
AZ_PUBLIC pred	P6_g_box(Frame*);
AZ_PUBLIC pred	P5_g_boxfill(Frame*);
AZ_PUBLIC pred	P6_g_line(Frame*);
AZ_PUBLIC pred	P2_g_linestyle(Frame*);
AZ_PUBLIC pred	P5_g_circle(Frame*);
AZ_PUBLIC pred	P4_g_paint(Frame*);
AZ_PUBLIC pred	P3_g_point(Frame*);
AZ_PUBLIC pred	P3_g_pset(Frame*);
AZ_PUBLIC pred	P2_g_origin(Frame*);
AZ_PUBLIC pred	P6_g_view(Frame*);
AZ_PUBLIC pred	P0_g_cls(Frame*);
AZ_PUBLIC pred	P1_g_color_mode(Frame*);
AZ_PUBLIC int	B4_g_screen(Frame*, TERM*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B2_g_color(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B3_g_color(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B6_g_box(Frame*, TERM*, TERM*, TERM*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B5_g_boxfill(Frame*, TERM*, TERM*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B6_g_line(Frame*, TERM*, TERM*, TERM*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B2_g_linestyle(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B5_g_circle(Frame*, TERM*, TERM*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B4_g_paint(Frame*, TERM*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_g_point(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_g_pset(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B2_g_origin(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B6_g_view(Frame*, TERM*, TERM*, TERM*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B1_g_color_mode(Frame*, TERM*);

/* main */
AZ_PUBLIC pred	P0_top_level(Frame*);
AZ_PUBLIC int	Parent_top_level(Frame*);
AZ_PUBLIC int	az_normalize_path(char*, int);
AZ_PUBLIC char*	az_add_os_depend_dir_sep(char*, int);
AZ_PUBLIC int	az_get_install_base_dir(char*, int);
AZ_PUBLIC int	B1_get_install_base_dir(Frame*, TERM*);
AZ_PUBLIC pred	P1_get_install_base_dir(Frame*);
AZ_PUBLIC int	B1_get_install_base_dir_normalized(Frame*, TERM*);
AZ_PUBLIC pred	P1_get_install_base_dir_normalized(Frame*);
AZ_PUBLIC pred	P0_break(Frame*);
AZ_PUBLIC pred	P0_unbreak(Frame*);
AZ_PUBLIC pred	P1_unbreak(Frame*);
AZ_PUBLIC int	B1_unbreak(Frame*, TERM*);
AZ_PUBLIC int	az_init(int, char**);
AZ_PUBLIC int	az_end(void);
AZ_PUBLIC int	az_exec(char*);
AZ_PUBLIC int	az_exec_unify(char* , int, ...);


/* meta */
AZ_PUBLIC pred	P1_atom(Frame*);
AZ_PUBLIC pred	P1_atomic(Frame*);
AZ_PUBLIC pred	P1_float(Frame*);
AZ_PUBLIC pred	P1_integer(Frame*);
AZ_PUBLIC pred	P1_number(Frame*);
AZ_PUBLIC pred	P1_list(Frame*);
AZ_PUBLIC pred	P1_compound(Frame*);
AZ_PUBLIC pred	P1_var(Frame*);
AZ_PUBLIC pred	P1_nonvar(Frame*);
AZ_PUBLIC pred	P2_length(Frame*);
AZ_PUBLIC pred	univ(Frame*);
AZ_PUBLIC pred	P3_functor(Frame*);
AZ_PUBLIC pred	P3_arg(Frame*);
AZ_PUBLIC int	B1_atom(Frame*, TERM*);
AZ_PUBLIC int	B1_atomic(Frame*, TERM*);
AZ_PUBLIC int	B1_float(Frame*, TERM*);
AZ_PUBLIC int	B1_integer(Frame*, TERM*);
AZ_PUBLIC int	B1_number(Frame*, TERM*);
AZ_PUBLIC int	B1_list(Frame*, TERM*);
AZ_PUBLIC int	B1_compound(Frame*, TERM*);
AZ_PUBLIC int	B1_var(Frame*, TERM*);
AZ_PUBLIC int	B1_nonvar(Frame*, TERM*);
AZ_PUBLIC int	B2_length(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B_univ(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B3_functor(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_arg(Frame*, TERM*, TERM*, TERM*);

/* numeric */
AZ_PUBLIC pred	eqnum(Frame*);
AZ_PUBLIC pred	noteqnum(Frame*);
AZ_PUBLIC pred	ltnum(Frame*);
AZ_PUBLIC pred	gtnum(Frame*);
AZ_PUBLIC pred	lenum(Frame*);
AZ_PUBLIC pred	genum(Frame*);
AZ_PUBLIC pred	P2_is(Frame*);
AZ_PUBLIC int	B_eqnum(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B_noteqnum(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B_ltnum(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B_gtnum(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B_lenum(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B_genum(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_is(Frame*, TERM*, TERM*);

/* read */
AZ_PUBLIC pred	P1_read(Frame*);
AZ_PUBLIC pred	P2_char_conversion(Frame*);
AZ_PUBLIC pred	P2_current_char_conv(Frame*);
AZ_PUBLIC int	PutCharConv(unsigned, unsigned);
AZ_PUBLIC int	B1_read(Frame*, TERM*);
AZ_PUBLIC int	B2_char_conversion(Frame*, TERM*, TERM*);

/* register */
AZ_PUBLIC pred	P3_a_register(Frame*);
AZ_PUBLIC pred	P3_e_register(Frame*);
AZ_PUBLIC pred	P3_f_register(Frame*);
AZ_PUBLIC pred	P3_e_switch(Frame*);
AZ_PUBLIC pred	P2_echo(Frame*);
AZ_PUBLIC pred	P2_kanji_mode(Frame*);
AZ_PUBLIC pred	P3_array_register(Frame*);
AZ_PUBLIC int	B3_a_register(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_e_register(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_f_register(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_e_switch(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B2_echo(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_kanji_mode(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B3_array_register(Frame*, TERM*, TERM*, TERM*);

/* save */
AZ_PUBLIC pred	P1_save(Frame*);
AZ_PUBLIC pred	P1_restore(Frame*);
AZ_PUBLIC int	B1_save(Frame*, TERM*);
AZ_PUBLIC int	B1_restore(Frame*, TERM*);

/* tools */
AZ_PUBLIC pred	P2_s_mStackSize(Frame*);
AZ_PUBLIC pred	P2_create_array(Frame*);
AZ_PUBLIC pred	P3_create_array(Frame*);
AZ_PUBLIC pred	P3_set_array(Frame*);
AZ_PUBLIC pred	P3_get_array(Frame*);
AZ_PUBLIC pred	P4_create_neuron(Frame*);
AZ_PUBLIC pred	P5_create_neuron(Frame*);
AZ_PUBLIC pred	P7_learn_neuron(Frame*);
AZ_PUBLIC pred	P6_learn_neuron(Frame*);
AZ_PUBLIC pred	P2_save_neuron(Frame*);
AZ_PUBLIC pred	P3_add_neuron(Frame*);
AZ_PUBLIC pred	P2_copy_neuron(Frame*);
AZ_PUBLIC pred	P2_load_neuron(Frame*);
AZ_PUBLIC pred	P3_inference_neuron(Frame*);
AZ_PUBLIC pred	P1_destroy_neuron(Frame*);
AZ_PUBLIC pred	P2_fuzzy_call(Frame*);
AZ_PUBLIC pred	P1_get_leash(Frame*);
AZ_PUBLIC pred	P1_get_leash1(Frame*);
AZ_PUBLIC pred	P2_g_getdefault(Frame*);
AZ_PUBLIC pred	P2_g_default(Frame*);
AZ_PUBLIC pred	P2_g_seedefault(Frame*);
AZ_PUBLIC pred	P2_g_setdefault(Frame*);
AZ_PUBLIC int	B2_s_mStackSize(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_create_array(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B3_create_array(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_set_array(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_get_array(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B4_create_neuron(Frame*, TERM*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B5_create_neuron(Frame*, TERM*, TERM*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B7_learn_neuron(Frame*, TERM*, TERM*, TERM*, TERM*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B6_learn_neuron(Frame*, TERM*, TERM*, TERM*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B2_save_neuron(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B3_add_neuron(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B2_copy_neuron(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_load_neuron(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B3_inference_neuron(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B1_destroy_neuron(Frame*, TERM*);
AZ_PUBLIC int	B2_fuzzy_call(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_get_leash(Frame*, TERM*);
AZ_PUBLIC int	B1_get_leash1(Frame*, TERM*);
AZ_PUBLIC int	B2_g_getdefault(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_g_default(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_g_seedefault(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_g_setdefault(Frame*, TERM*, TERM*);

/* type */
AZ_PUBLIC pred	P2_s_charset(Frame*);
AZ_PUBLIC int	B2_s_charset(Frame*, TERM*, TERM*);
AZ_PUBLIC int	az_charsetmode(void);
AZ_PUBLIC int	az_enc_len(int, const unsigned char*);
AZ_PUBLIC int	az_enc_len_utf8(const unsigned char*);
AZ_PUBLIC int	az_enc_len_eucjp(const unsigned char*);
AZ_PUBLIC int	az_enc_len_sjis(const unsigned char*);

/* unify */
struct _Stream;

AZ_PUBLIC pred	equal(Frame*);
AZ_PUBLIC pred	not_unify(Frame*);
AZ_PUBLIC int	unifyE(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B_equal(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B_not_unify(Frame*, TERM*, TERM*);
AZ_PUBLIC int	unify_atomE(Frame*, TERM*, BASEINT);
AZ_PUBLIC int	unify_nilE(Frame*, TERM*);
AZ_PUBLIC int	unify_intE(Frame*, TERM*, SBASEINT);
AZ_PUBLIC int	unify_fhE(Frame*, TERM*, struct _Stream*);
AZ_PUBLIC int	unify_arrayE(Frame*, TERM*, TERM*);

AZ_PUBLIC int	unify_atomE_ex(Frame*, TERM*, BASEINT);
AZ_PUBLIC int	unify_nilE_ex(Frame*, TERM*);
AZ_PUBLIC int	unify_intE_ex(Frame*, TERM*, SBASEINT);
AZ_PUBLIC int	unify_fhE_ex(Frame*, TERM*, struct _Stream*);
AZ_PUBLIC int	unify_arrayE_ex(Frame*, TERM*, TERM*);
AZ_PUBLIC int	unify_after_call(Frame*);
AZ_PUBLIC int	unifyE_ex(Frame*, TERM*, TERM*);
AZ_PUBLIC int	unify_clp(Frame*, TERM*, TERM*);
AZ_PUBLIC int	unify_clp_ex(Frame*, TERM*, TERM*);

#define FROZEN_GOAL_CALL(env,Else)	\
	if(frozen_goal_register!=(TERM*)0){ if(!unify_after_call(env)) Else; }

#define	unify(a,b)		unifyE(Env,a,b)
#define	unify_atom(a,b)		unify_atomE(Env,a,b)
#define	unify_nil(a)		unify_nilE(Env,a)
#define	unify_int(a,b)		unify_intE(Env,a,b)
#define	unify_fh(a,b)		unify_fhE(Env,a,b)
#define	unify_array(a,b)	unify_arrayE(Env,a,b)

/* utility */
AZ_PUBLIC int	az_list_len(TERM*);
AZ_PUBLIC int	az_cstring_to_list(Frame*, const char*, int, TERM*);
AZ_PUBLIC int	az_term_to_cstring_length(Frame*, TERM*);
AZ_PUBLIC int	az_term_to_cstring(Frame*, TERM*, char*, int);

AZ_PUBLIC pred	S0_cut(Frame*, Frame*);
AZ_PUBLIC pred	S0_fail(void);
AZ_PUBLIC pred	S0_true(void);
AZ_PUBLIC pred	P3_get_builtin(Frame*);
AZ_PUBLIC pred	P6_get_builtin(Frame*);
AZ_PUBLIC int	GetFlatListE(Frame*, TERM*, unsigned int, ...);
AZ_PUBLIC int	GetNListE(Frame*, TERM*, unsigned int, TERM*, ...);
AZ_PUBLIC int	UnifyFlatListE(Frame*, TERM*, unsigned int, ...);
AZ_PUBLIC int	UnifyListE(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	UnifyNListE(Frame*, TERM*, unsigned int, TERM*, ...);
AZ_PUBLIC int	UnifyNList2E(Frame*, TERM*, unsigned int, TERM*, ...);
AZ_PUBLIC int	UnifyNListGetCdrE(Frame*, TERM*, unsigned int, TERM*, ...);
AZ_PUBLIC int	GetTermE(Frame*, TERM*, BASEINT, unsigned int, ...);
AZ_PUBLIC int	UnifyTermE(Frame*, TERM*, BASEINT, unsigned int, ...);
AZ_PUBLIC int	GetCarUnifyCdrE(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	UnifyAtomCarOverWriteCdrE(Frame*, TERM*, BASEINT);
AZ_PUBLIC int	UnifyAtomCarGetCdrE(Frame*, TERM*, BASEINT, TERM*);
AZ_PUBLIC int	GetCarOverWriteCdrE(Frame*, TERM*, TERM*);
AZ_PUBLIC int	OverWriteCarGetCdrE(Frame*, TERM*, TERM*);
AZ_PUBLIC int	GetListE(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	GetCarSelfE(Frame*, TERM*);
AZ_PUBLIC int	GetCar1E(Frame*, TERM*, TERM*);
AZ_PUBLIC int	GetCdrSelfE(Frame*, TERM*);
AZ_PUBLIC int	UnifyCarE(Frame*, TERM*, TERM*);
AZ_PUBLIC int	UnifyCar1E(Frame*, TERM*, TERM*);
AZ_PUBLIC int	UnifyCdrE(Frame*, TERM*, TERM*);
AZ_PUBLIC int	DoListE(Frame*, TERM*);
AZ_PUBLIC int	DoList1E(Frame*, TERM*);
AZ_PUBLIC int	OverWriteCarUnifyCdrE(Frame*, TERM*, TERM*);
AZ_PUBLIC int	UnifyCarOverWriteCdrE(Frame*, TERM*, TERM*);
AZ_PUBLIC int	UnifyNilE(Frame*, TERM*);
AZ_PUBLIC int	GetCommonCarListsE(Frame*, TERM*, TERM*);
AZ_PUBLIC int	UnifyCarGetCdrE(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	GetCarE(Frame*, TERM*, TERM*);
AZ_PUBLIC int	GetCdrE(Frame*, TERM*, TERM*);
AZ_PUBLIC int	GetCarSelf1E(Frame*, TERM*);

#define	GetFlatList(a,b,...)		GetFlatListE(Env,a,b,__VA_ARGS__)
#define	GetNList(a,b,c,...)		GetNListE(Env,a,b,c,__VA_ARGS__)
#define	UnifyFlatList(a,b,...)		UnifyFlatListE(Env,a,b,__VA_ARGS__)
#define	UnifyList(a,b,c)		UnifyListE(Env,a,b,c)
#define	UnifyNList(a,b,c,...)		UnifyNListE(Env,a,b,c,__VA_ARGS__)
#define	UnifyNList2(a,b,c,...)		UnifyNList2E(Env,a,b,c,__VA_ARGS__)
#define	UnifyNListGetCdr(a,b,c,...)	UnifyNListGetCdrE(Env,a,b,c,__VA_ARGS__)
#define	GetTerm(a,b,c,...)		GetTermE(Env,a,b,c,__VA_ARGS__)
#define	UnifyTerm(a,b,c,...)		UnifyTermE(Env,a,b,c,__VA_ARGS__)
#define	GetCarUnifyCdr(a,b,c)		GetCarUnifyCdrE(Env,a,b,c)
#define	UnifyAtomCarOverWriteCdr(a,b)	UnifyAtomCarOverWriteCdrE(Env,a,b)
#define	UnifyAtomCarGetCdr(a,b,c)	UnifyAtomCarGetCdrE(Env,a,b,c)
#define	GetCarOverWriteCdr(a,b)		GetCarOverWriteCdrE(Env,a,b)
#define	OverWriteCarGetCdr(a,b)		OverWriteCarGetCdrE(Env,a,b)
#define	GetList(a,b,c)			GetListE(Env,a,b,c)
#define	GetCarSelf(a)			GetCarSelfE(Env,s)
#define	GetCar1(a,b)			GetCar1E(Env,a,b)
#define	GetCdrSelf(a)			GetCdrSelfE(Env,a)
#define	UnifyCar(a,b)			UnifyCarE(Env,a,b)
#define	UnifyCar1(a,b)			UnifyCar1E(Env,a,b)
#define	UnifyCdr(a,b)			UnifyCdrE(Env,a,b)
#define	DoList(a)			DoListE(Env,a)
#define	OverWriteCarUnifyCdr(a,b)	OverWriteCarUnifyCdrE(Env,a,b)
#define	UnifyCarOverWriteCdr(a,b)	UnifyCarOverWriteCdrE(Env,a,b)
#define	UnifyNil(a)			UnifyNilE(Env,a)
#define	GetCommonCarLists(a,b)		GetCommonCarListsE(Env,a,b)
#define	UnifyCarGetCdr(a,b,c)		UnifyCarGetCdrE(Env,a,b,c)
#define	GetCar(a,b)			GetCarE(Env,a,b)
#define	GetCdr(a,b)			GetCdrE(Env,a,b)
#define	GetCarSelf1(a)			GetCarSelf1E(Env,a)

AZ_PUBLIC void	PutTerm(Frame*, TERM*, BASEINT, unsigned int, ...);
AZ_PUBLIC void	PutNList(Frame*, TERM*, unsigned int, TERM*, ...);
AZ_PUBLIC int	CompareValue(TERM*, BASEINT);
AZ_PUBLIC int	IsIntOf(TERM*, BASEINT);
AZ_PUBLIC int	IsAtomOf(TERM*, BASEINT);
AZ_PUBLIC void	PutStructure(Frame*, Frame*, int, TERM*, TERM*);
AZ_PUBLIC void	PutList(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC void	Put1List(Frame*, TERM*, TERM*);
AZ_PUBLIC void	PutVarC(TERM*, TERM*);
AZ_PUBLIC void	S_PUTVAL(TERM*,TERM*);
AZ_PUBLIC void	GvClears(TERM*, unsigned);
AZ_PUBLIC void	S_LINK0(Frame*);
AZ_PUBLIC void	S_LINK(Frame*, int, int);
AZ_PUBLIC void	S_LINK1(Frame*, int, int);
AZ_PUBLIC void	S_LINK1Z(Frame*, int);
AZ_PUBLIC void	S_LINK1ZZ(Frame*);
AZ_PUBLIC void	S_RELINKZ(Frame*);
AZ_PUBLIC void	S_RELINK(Frame*, int);
AZ_PUBLIC void	set_user_heap(UTERM*, UTERM*, BASEINT*, int);
AZ_PUBLIC void	set_user_atom(BASEINT*, int);
AZ_PUBLIC void	sort_index_table(IndexPtr, BASEINT);
AZ_PUBLIC int	find_atom_index(IndexPtr, TERM*, int);
AZ_PUBLIC int	find_term_index(IndexPtr, TERM*, int);
AZ_PUBLIC int	GetCommonCarLists2(Frame*, TERM*, TERM*);
AZ_PUBLIC int	get_intcar_with_overwrite(TERM*, BASEINT*);
AZ_PUBLIC int	get_list_pointer(TERM*, TERM**, TERM**);
AZ_PUBLIC int	get_car_with_overwrite(TERM**, TERM**);
AZ_PUBLIC int	copy_list(Frame*, TERM**, TERM**);
AZ_PUBLIC int	inc(TERM*);
AZ_PUBLIC int	dec(TERM*);
AZ_PUBLIC void	LocalOverflow(void);
AZ_PUBLIC void	TrailOverflow(void);
AZ_PUBLIC void	ArgError(void);
AZ_PUBLIC int	byte_debug(Frame*);
AZ_PUBLIC int	sss_find_index(IndexPtr, int, BASEINT,  int);
AZ_PUBLIC int	ss_find_int_index(IndexPtr, TERM*, int, int);
AZ_PUBLIC int	ss_find_atom_index(IndexPtr, TERM*, int, int);
AZ_PUBLIC int	ss_find_term_index(IndexPtr, TERM*, int, int);
AZ_PUBLIC int	ss_find_index(IndexPtr, IndexPtr, IndexPtr, int, int, int, TERM*, int);
AZ_PUBLIC int	ss_find_ia_index(IndexPtr, IndexPtr, int, int, TERM*, int);
AZ_PUBLIC int	ss_find_it_index(IndexPtr, IndexPtr, int, int, TERM*, int);
AZ_PUBLIC int	ss_find_at_index(IndexPtr, IndexPtr, int, int, TERM*, int);
AZ_PUBLIC void	sort_index_table2(IndexPtr, BASEINT);
AZ_PUBLIC void	set_index_table(IndexTable*, unsigned int);
AZ_PUBLIC void	init_copy_set_user_atom(char* [], const char* [], int);
AZ_PUBLIC void	init_copy_set_user_heap(UTERM [], UTERM [], int);
AZ_PUBLIC void	init_copy_set_index_table(IndexTable [], IndexTable [], int);
AZ_PUBLIC int	c_debug(Frame*, int, int, int, char*);

/* winapi */
AZ_PUBLIC pred	P2_winLoadLibrary(Frame*);
AZ_PUBLIC pred	P3_winGetProcAddress(Frame*);
AZ_PUBLIC pred	P2_winAllocApiArg(Frame*);
AZ_PUBLIC pred	P1_winFreeApiArg(Frame*);
AZ_PUBLIC pred	P3_winStoreApiArgQWORD(Frame*);
AZ_PUBLIC pred	P3_winLoadApiArgQWORD(Frame*);
AZ_PUBLIC pred	P3_winStoreApiArgDWORD(Frame*);
AZ_PUBLIC pred	P3_winLoadApiArgDWORD(Frame*);
AZ_PUBLIC pred	P3_winStoreApiArgWORD(Frame*);
AZ_PUBLIC pred	P3_winLoadApiArgWORD(Frame*);
AZ_PUBLIC pred	P3_winStoreApiArgBYTE(Frame*);
AZ_PUBLIC pred	P3_winLoadApiArgBYTE(Frame*);
AZ_PUBLIC pred	P3_winStoreApiArgFLOAT(Frame*);
AZ_PUBLIC pred	P3_winLoadApiArgFLOAT(Frame*);
AZ_PUBLIC pred	P7_winCallApi(Frame*);
AZ_PUBLIC pred	P1_winWindowProc(Frame*);
AZ_PUBLIC pred	P1_winDialogProc(Frame*);
AZ_PUBLIC pred	P1_winCallbackProc2Args(Frame*);
AZ_PUBLIC pred	P1_winCallbackProc3Args(Frame*);
AZ_PUBLIC pred	P1_winCallbackProc4Args(Frame*);
AZ_PUBLIC pred	P1_winCallbackProc5Args(Frame*);
AZ_PUBLIC pred	P1_winAbortProc(Frame*);
AZ_PUBLIC pred	P1_winDdeCallback(Frame*);
AZ_PUBLIC pred	P1_winEditWordBreakProc(Frame*);
AZ_PUBLIC pred	P1_winFileIOCompletionRoutine(Frame*);
AZ_PUBLIC pred	P1_winOutputProc(Frame*);
AZ_PUBLIC pred	P1_winSendAsyncProc(Frame*);
AZ_PUBLIC pred	P1_winTimerProc(Frame*);
AZ_PUBLIC pred	P1_winVtblMemberProc(Frame*);
AZ_PUBLIC pred	P6_winReturnProc(Frame*);
AZ_PUBLIC pred	P2_winGetWinMainArgs(Frame*);
AZ_PUBLIC int	B2_winLoadLibrary(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B3_winGetProcAddress(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B2_winAllocApiArg(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_winFreeApiArg(Frame*, TERM*);
AZ_PUBLIC int	B3_winStoreApiArgQWORD(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_winLoadApiArgQWORD(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_winStoreApiArgDWORD(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_winLoadApiArgDWORD(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_winStoreApiArgWORD(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_winLoadApiArgWORD(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_winStoreApiArgBYTE(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_winLoadApiArgBYTE(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_winStoreApiArgFLOAT(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_winLoadApiArgFLOAT(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B7_winCallApi(Frame*, TERM*, TERM*, TERM*, TERM*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B1_winWindowProc(Frame*, TERM*);
AZ_PUBLIC int	B1_winDialogProc(Frame*, TERM*);
AZ_PUBLIC int	B1_winCallbackProc2Args(Frame*, TERM*);
AZ_PUBLIC int	B1_winCallbackProc3Args(Frame*, TERM*);
AZ_PUBLIC int	B1_winCallbackProc4Args(Frame*, TERM*);
AZ_PUBLIC int	B1_winCallbackProc5Args(Frame*, TERM*);
AZ_PUBLIC int	B1_winAbortProc(Frame*, TERM*);
AZ_PUBLIC int	B1_winDdeCallback(Frame*, TERM*);
AZ_PUBLIC int	B1_winEditWordBreakProc(Frame*, TERM*);
AZ_PUBLIC int	B1_winFileIOCompletionRoutine(Frame*, TERM*);
AZ_PUBLIC int	B1_winOutputProc(Frame*, TERM*);
AZ_PUBLIC int	B1_winSendAsyncProc(Frame*, TERM*);
AZ_PUBLIC int	B1_winTimerProc(Frame*, TERM*);
AZ_PUBLIC int	B1_winVtblMemberProc(Frame*, TERM*);
AZ_PUBLIC int	B6_winReturnProc(Frame*, TERM*, TERM*, TERM*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B2_winGetWinMainArgs(Frame*, TERM*, TERM*);

/* write */
AZ_PUBLIC pred	P1_write(Frame*);
AZ_PUBLIC pred	P1_writeq(Frame*);
AZ_PUBLIC pred	P2_display(Frame*);
AZ_PUBLIC pred	P1_display(Frame*);
AZ_PUBLIC pred	P2_set_write_depth(Frame*);
AZ_PUBLIC pred	P2_set_write_list_length(Frame*);
AZ_PUBLIC int	B2_set_write_depth(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_set_write_list_length(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_write(Frame*, TERM*);
AZ_PUBLIC int	B1_writeq(Frame*, TERM*);
AZ_PUBLIC int	B2_display(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B1_display(Frame*, TERM*);

/* compiled predicates from oleauto.pl */
AZ_PUBLIC pred	P3_automation(Frame*);
AZ_PUBLIC pred	P0_ole_initialize(Frame*);
AZ_PUBLIC pred	P0_ole_uninitialize(Frame*);
AZ_PUBLIC pred	P2_ole_create_object(Frame*);
AZ_PUBLIC pred	P1_ole_release_object(Frame*);
AZ_PUBLIC pred	P5_ole_call_method(Frame*);
AZ_PUBLIC pred	P5_ole_get_property(Frame*);
AZ_PUBLIC pred	P4_ole_put_property(Frame*);

/* clp_unit */
AZ_PUBLIC pred	P1_unfreeze(Frame*);
AZ_PUBLIC pred	P2_freeze(Frame*);
AZ_PUBLIC pred	P2_frozen(Frame*);
AZ_PUBLIC pred	P2_get_clp_area(Frame*);
AZ_PUBLIC pred	P2_put_clp_area(Frame*);
AZ_PUBLIC pred	P2_rm_clp_area(Frame*);
AZ_PUBLIC pred	P3_rm_area(Frame*);
AZ_PUBLIC int	B3_rm_area(Frame*, TERM*, TERM*, TERM*); 
AZ_PUBLIC pred	P2_clp_is_member(Frame*);
AZ_PUBLIC pred	P2_system_get_min_max_int(Frame*);
AZ_PUBLIC pred	P2_system_get_tag(Frame*);
AZ_PUBLIC pred	P3_clp_intersection(Frame*);
AZ_PUBLIC int	B1_unfreeze(Frame*, TERM*);
AZ_PUBLIC int	B2_freeze(Frame*,TERM*, TERM*);
AZ_PUBLIC int	B2_frozen(Frame*,TERM*, TERM*);
AZ_PUBLIC int	B2_get_clp_area(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_put_clp_area(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_rm_clp_area(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B3_outof(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B3_clp_intersection(Frame*, TERM*, TERM*, TERM*);
AZ_PUBLIC int	B2_clp_is_member(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_system_get_min_max_int(Frame*, TERM*, TERM*);
AZ_PUBLIC int	B2_system_get_tag(Frame*, TERM*, TERM*);

/* dlib */
AZ_PUBLIC int	B1_dlib_require(Frame*, TERM*);
AZ_PUBLIC pred	P1_dlib_require(Frame*);
AZ_PUBLIC int	B2_dlib_require(Frame*, TERM*, TERM*);
AZ_PUBLIC pred	P2_dlib_require(Frame*);
AZ_PUBLIC int	B1_dlib_get_error_str(Frame*, TERM*);
AZ_PUBLIC pred	P1_dlib_get_error_str(Frame*);
AZ_PUBLIC int	B1_dlib_get_load_map(Frame*, TERM*);
AZ_PUBLIC pred	P1_dlib_get_load_map(Frame*);
AZ_PUBLIC int	B1_dlib_get_search_path(Frame*, TERM*);
AZ_PUBLIC pred	P1_dlib_get_search_path(Frame*);
AZ_PUBLIC int	B1_dlib_set_search_path(Frame*, TERM*);
AZ_PUBLIC pred	P1_dlib_set_search_path(Frame*);
AZ_PUBLIC int	B1_dlib_search_path_push(Frame*, TERM*);
AZ_PUBLIC pred	P1_dlib_search_path_push(Frame*);
AZ_PUBLIC int	B0_dlib_search_path_pop(Frame*);
AZ_PUBLIC pred	P0_dlib_search_path_pop(Frame*);
AZ_PUBLIC int	dlib_free(void);

AZ_PUBLIC void	StoAssert(char*);

#ifdef __cplusplus
}
#endif

#endif	/* end of azprolog.h */

