%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%%  SSL認証局へ証明書ファイル(root.pem,key.pem)で認証を行い
%%  データの送受信を行う
%%
%% ---------------------------------------------------------
%%  [使用述語]
%%  client_connect,ssl_cert_load_file,ssl_cert_send,
%%  ssl_cert_receive,socket_close,ssl_cert_close
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:-dlib_require(socket).
:-dlib_require(socket_ssl).
test:-
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  認証サーバーに接続する                       %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	client_connect('127.0.0.1','3000',S),

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  サーバー証明書ファイルで認証要求を行う       %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	ssl_cert_load_file(S,'root.pem','key.pem',SN),

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  認証サーバーへデータを送信する               %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	name(C,[10]),
	Data1='Cert Test Message',
	atom_concat(Data1,C,Data),
	ssl_cert_send(SN,Data),

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  認証サーバーからデータを受信する             %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	get_all(SN,"",LAns),
	name(Ans,LAns),
	write(Ans),nl,

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  認証サーバーの切断                           %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	socket_close(S),
	ssl_cert_close(SN).


get_all(SN,Bef,Ans):-
    ssl_cert_receive(SN,Out,Sz),name(Out,OutL),length(OutL,N),N>0,!,
    append(Bef,OutL,NextBef),
    get_all(SN,NextBef,Ans).
get_all(SN,A,A).

