%%   Make Prolog.system.rslt File 
%%   From B-Prolog's-Site-Data & SWI-Prolog-Real-Measured-Data %%%

%% Compile
%% > azpc -p mk_rslt.pl /e mk_rslt 
%% > mk_rslt
%% Interpreter
%% > prolog_c -s mk_rslt.pl 
%% ?- top_level.

top_level:-
	Base = 'SWI-Prolog.rslt',
	consult(Base),
	prolog_diff_name(IDS),
	make_new_file(IDS,Files),
	conc('SWI-Prolog',Module,Time,Result),
		prolog_diff(Module,B,E,G,S,SWI,X,Y),
		Rate is Time/SWI,
		add_data(Files,IDS,Module,Rate,[B,E,G,S,X,Y],[]),
	fail.

make_new_file([],[]):-!.
make_new_file([A|B],[AF|C]):- 
	atom_append(A,'.rslt',AF),tell(AF),told,make_new_file(B,C).

add_data([],[],_,_,[],_):-!.
add_data([File|Files],[ID|IDS],Module,Rate,[MyTime|Times],Result):-
	Time is MyTime*Rate,
	tella(File),
		display(conc(ID,Module,Time,Result)),write('.'),nl,
	told,
	add_data(Files,IDS,Module,Rate,Times,Result).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Under Data is Written on B-Prolog's Site %%%%
%%%  http://www.probp.com/performance.htm    %%%%

%%%%
prolog_diff_name(['B-Prolog','EP', 'GNU-Prolog','SICStus-Prolog', 'XSB','YAP']).

%%                          BP EP    GNU   SICSt SWI   XSB    YAP
prolog_diff(boyer,          1, 1.70, 6.09, 1.24, 4.59, 7.89,  1.56).
prolog_diff(browse,         1, 1.68, 6.23, 1.23, 3.79, 6.29,  1.55).
prolog_diff(chat_parser,    1, 1.52, 3.62, 1.30, 2.83, 3.92,  1.32).
prolog_diff(crypt,          1, 1.64, 6.53, 1.55, 5.46, 5.46,  1.86).
prolog_diff(fast_mu,        1, 1.94, 6.06, 1.28, 4.44, 5.94,  1.56).
prolog_diff(flatten,        1, 1.41, 5.51, 1.15, 3.86, 9.71,  1.40).
prolog_diff(meta_qsort,     1, 1.17, 4.90, 0.83, 3.17, 4.82,  1.16).
prolog_diff(mu,             1, 1.69, 4.43, 0.96, 3.38, 4.83,  1.57).
prolog_diff(nreverse,       1, 3.41, 9.08, 1.34, 9.81, 22.63, 1.51).
prolog_diff(poly,           1, 2.16, 4.86, 1.25, 3.88, 6.47,  1.82).
prolog_diff(prover,         1, 1.64, 3.78, 1.00, 3.05, 4.95,  1.61).
prolog_diff(qsort,          1, 2.31, 5.84, 1.00, 4.18, 5.95,  1.29).
prolog_diff(queens,         1, 1.60, 11.30,1.11, 5.96, 6.92,  1.58).
prolog_diff(query,          1, 1.54, 5.16, 0.93, 3.62, 4.77,  1.54).
prolog_diff(reducer,        1, 1.84, 4.97, 1.52, 3.73, 6.28,  1.62).
prolog_diff(sendmore,       1, 2.97, 10.27,1.72, 6.15, 7.80,  1.80).
prolog_diff(simple_analyzer,1, 1.62, 4.06, 1.06, 3.44, 5.47,  1.32).
prolog_diff(tak,            1, 3.72, 16.16,2.18, 8.16, 13.20, 4.59).
prolog_diff(unify,          1, 2.78, 10.74,1.99, 7.07, 11.52, 3.03).
prolog_diff(zebra,          1, 1.09, 1.45, 0.78, 2.07, 2.54,  0.85).

