#!/usr/local/bin/prologcgi

:-s_charset(_,utf8).
top_call:-
  param_assoc_list(Param),        % 起動パラメータ一覧を連想ペアリストで取得する。[タグ名1,値１,タグ名2,値2,...]
  html_call([
    "Content-Type: text/html; charset=utf-8

     <html lang='ja'><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'>
     <title>ニューラルネットワーク組込述語</title></head> 
     <body><center><H1>ニューラルネットワーク組込述語</H1> 
     <a href='./disp_abc.cgi'>ＡＢＣフォントの学習データ表示　</a>
     <a href='puttxt.exe?neurontest.cgi' target='source'>このページのソース表示　</a>
     <INPUT TYPE='button' VALUE='RETURN' onClick='history.back()'><br><br> 
     下のボックスにマウスでチェックしながらＡＢＣの何れかの文字を書いて「推論」ボタンを押してください<br>
     ＡＢＣパターン学習済のニューラルネットワークオブジェクトを使って入力パターンが何かを推論します
      <form action='neurontest.cgi' method='POST'>
         <table  border='2' ><tr><td>",
            call(write_checkbox(1,Param,FontList)),      % 5X7のフォント入力域チェックリストと入力層リストを生成
        "</td></tr></table>
        <input type='submit' value='推論'>
      </form> <H3>",
        call(inference(Param,FontList)),                 % 入力層リストから推論し結果を出力
     "</H3></center></body></html>"]).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% ニューラルネットワークによる推論

inference([] ,_ ):-                                     % チェックボックスに一つもチェックがない場合
    !,write(マウスチェックでＡＢＣの何れかの文字を書き【推論】ボタンを押してください).

inference(_,FontList):-
    create_neuron(35,10,3,Neuron),                      % ★ ニューラルネットワークを生成する（入力層=35,中間層=10,出力層=3)
    load_neuron(Neuron,abcfont),!,                      % ★ A,B,Cフォントパターン学習済のオブジェクトをロードする
    inference_neuron(Neuron,FontList,[A,B,C]),          % ★ 学習済みオブジェクトを利用して入力フォントパターンを推論
    s_qsort(dec,[A='Ａ',B='Ｂ',C='Ｃ'],[X=G,Y=H,Z=I]),  % 結果を降順でソートする（コンパイル組込み述語　setof.pl)
    write_listnl(['推論結果::　',G,'<br>']),
    write_listnl([G=X,'　',H=Y,'　',I=Z]).

inference(_,_):-
    write(学習済データがありません).

%%%% 引数パラメータから、チェック有り無しのチェックボックス出力と入力層のフォントパターンリストを生成する
%%%% 引数パラメータはチェックされているものだけからなる。 neurontest.cgi?x=10&x=15&x=16&x=20
%%%% チェックボックスは同一タグ名(x)で1〜３５（５Ｘ７個）の値をとる。(左上⇒右上、左２段⇒右２段．．．右下）

%%  write_checkbox(+カウンタ,+引数パラメータ,-入力層パターンリスト). % [x,1,x,3...⇒ [1.0, 0.0, 1.0 .....

write_checkbox(36,_,     []):-!.
write_checkbox(N,[x,N|L],[1.0|R]):- !,write_checkbox2(N,L,R,checked).     % 該当位置がチェックされている
write_checkbox(N,L,      [0.0|R]):- write_checkbox2(N,L,R,'').            % 該当位置はチェックされていない

write_checkbox2(N,L,R,Checked):- 
    write_list(['<input type="checkbox" name="x" value=',N,' ',Checked,' >']),  % チェックボックス出力
    (0 is N mod 5 ->write('<br>'),nl;true),           % ５個ごとに改行する
    NN is N+1,write_checkbox(NN,L,R).                 % カウントアップし、次のチェックボックスへ(相互再帰)
