/* websock test program. */
:- kanji_mode(_,off).

require(X):- ws_version(_), !.  % for built-in library case.
require(X):- dlib_require(X), !,
  write('Library Loaded: '), ws_version(V), write(V), nl.
require(X):- dlib_get_error_str(S), name(E, S), write(E), nl.

:- require(websock).

/* SSLを使用しない */
t:- test(0).

/* SSLを使用 */
t1:- test(1).

/* SSLを使用 (以下のケースを無視する)
SSL_get_verify_result(SSL *ssl)の返り値 18
18 X509_V_ERR_DEPTH_ZERO_SELF_SIGNED_CERT 渡されたルートCA証明書は信頼された証明書リストに存在しない
*/
t2:- test(2).

test(SSL):-
  %ws_set_log_level(['WS_LL_ERR', 'WS_LL_WARN', 'WS_LL_NOTICE', 'WS_LL_INFO', 'WS_LL_DEBUG', 'WS_LL_PARSER', 'WS_LL_HEADER', 'WS_LL_EXT', 'WS_LL_CLIENT', 'WS_LL_LATENCY']),
  (SSL > 0 ->
      w('Set Client Certificate...'),
      ws_set_client_certificate_file_path('/var/cert/certs/user.crt'),
      ws_set_client_private_key_file_path('/var/cert/keys/user.key'),
      w('Set Client Certificate end.');
      true),
  w('Test Start.'),
  ws_create_context(['simple-rr', 'foo'], 0, CONTEXT),
  w('ws_connect'),
  ws_connect(5000, CONTEXT, 'simple-rr', 'localhost', 8080, SSL, '/echo', 'localhost', 'localhost', SESSION),
  ws_sub_protocol(SESSION, SUB_PROTOCOL),
  w(SUB_PROTOCOL),
  repeat_test(3, SESSION),
  w('ws_close'),
  ws_close(SESSION),
  w('sleep'),
  s_sleep(1000),
  w('ws_delete_context'),
  ws_delete_context(CONTEXT),
  w('Test End.'),
  ws_version(VERSION), write('Version: '), w(VERSION).


repeat_test(N, SESSION):-
  repeat(I),
  test_write_and_read(SESSION),    
  test_pong(SESSION),
  test_size(SESSION, [1, 2, 3, 5, 10, 30, 100, 200, 1000, 4094, 4095, 4096, 4097, 4098, 50000, 60000, 65535]),
  I1 is I + 1,
  write('--- REPEAT '), write(I1), write(' END. ---'), nl,
  I1 >= N.

test_write_and_read(SESSION):-
  w('ws_write_text'),
  ws_write_text(SESSION, '*** ロムニー候補は、就任したその日から中国を「為替操作国」と呼ぶと持論を展開し、対中貿易赤字が大きくなりすぎているとオバマ大統領の政策を批判しました。一方、オバマ大統領は'),
  LIST_DATA = [0,1,2,3,127,128,254,255],
  w('ws_write_list_binary'),
  ws_write_list_binary(SESSION, LIST_DATA),
  ws_write_atom_list(SESSION,
    ['*** ロムニー候補は、就任したその日から', 
    '中国を「為替操作国」と呼ぶと持論を展開し、',
    '対中貿易赤字が大きくなりすぎているとオバマ大統領の政策を',
    '批判しました。'
    ]),
  w('ws_read_text'),
  ws_read_text(5000, SESSION, READ_TEXT_DATA1),
  w(READ_TEXT_DATA1),
  w('ws_read_list'),
  ws_read_list(5000, SESSION, READ_DATA),
  w(READ_DATA),
  w('ws_read_text'),
  ws_read_text(5000, SESSION, READ_TEXT_DATA2),
  w(READ_TEXT_DATA2).

test_pong(SESSION):-
  w('ws_write_text'),
  ws_write_text(SESSION, 'スターダスト藤井リナ契約解除は関東連合・六本木襲撃事件の関係か!?'),
  s_sleep(18000),
  w('pong'),
  ws_write_pong(SESSION),
  s_sleep(14000),
  w('ws_read_text'),
  ws_read_text(5000, SESSION, READ_TEXT_DATA),
  w(READ_TEXT_DATA),
  w('pong'),
  ws_write_pong(SESSION).

test_size(SESSION, []):- !.
test_size(SESSION, [N|T]):-
  test_size1(SESSION, N),
  test_size(SESSION, T).

test_size1(SESSION, TEXT_LEN):-
  write('text size: '), write(TEXT_LEN), nl,
  make_size_text(TEXT_LEN, LTEXT),
  name(TEXT, LTEXT),
  %w('ws_write_text'),
  ws_write_text(SESSION, TEXT),
  %w('read_size_text'),
  read_size_text(5000, SESSION, TEXT_LEN, L_DATA),
  atom_list_length(L_DATA, GET_LEN),
  write('get size: '), w(GET_LEN).


read_size_text(TIMEOUT, SESSION, LEN, []):- LEN =< 0, !.
read_size_text(TIMEOUT, SESSION, LEN, [DATA|L]):-
  ws_read_text(TIMEOUT, SESSION, DATA),
  atom_length(DATA, DATA_LEN),
  REM is LEN - DATA_LEN,
  read_size_text(TIMEOUT, SESSION, REM, L).

make_size_text(0, []):- !.
make_size_text(1, [90]):- !.
make_size_text(N, L):-
  N1 is N - 1,
  L = [65|L1],
  make_size_text(N1, L1).

atom_list_length([], 0).
atom_list_length([H|T], LEN):-
  atom_length(H, HLEN),
  atom_list_length(T, TLEN),
  LEN is HLEN + TLEN.

w(S):- write(S), nl.
