%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%%  SSLサイトよりファイルをダウンロードする
%%
%% ---------------------------------------------------------
%%  [使用述語]
%%  ssl_client_connect,socket_ssl_download,ssl_socket_close
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:-dlib_require(socket).
:-dlib_require(socket_ssl).
test:-
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  サーバーへHTTP接続を行う                          %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	host2ip('www.az-prolog.com',GH,AH,IP),
	ssl_client_connect(IP,'443','RSA',S),
	P1='GET /socket_check/download.tgz HTTP/1.1',
	name(C,[10]),
	atom_concat(P1,C,P2),
	atom_concat(P2,'Host: ',P3),
	atom_concat(P3,IP,P4),
	atom_concat(P4,C,P5),
	atom_concat(P5,'Connection: Close',P6),
	atom_concat(P6,C,P7),
	atom_concat(P7,C,Get),

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  サーバーへGET命令を送信し、ダウンロードを行う     %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	ssl_socket_send(S,Get),
	socket_ssl_download(S, 'test.tgz'),

	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	%%  サーバーの切断を行う                              %%
	%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    ssl_socket_close(S).

