%%%%%%%%%%%%%%%%%%%%%%%%% hpsg.p %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%	Simple	HPSG parser
%%			1994.5.20
%%      grammar by G.Smolka
%%      programmed by H.Tsuda
%%      Modify For AZ-Prolog V9 by T.Inaba(SOFNEC) 2015.9.25
%%
%%    {head/_, sc/_, ph/_}
%% ----------------------------------------------------
%%	head: head feature
%%	sc:   subcat feature
%%	ph:   phnological feature
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Example.
%%  ?- p([mary,meets,john]).
%%  ?- p([the,girl,is,mary]).
%%  ?- p([mary,is,embarrassed]).
%%  ?- p([mary,thinks,john,is,nice]).
%%
:- [-'tree.pl'].    % Cu-Prolog builtin pred (tree/1 etc) for AZ

%%  Left Corner Parser
p(Sentence):-
	parse0(Cat,H,Sentence,[]),tree(H).

parse0(MCat,MHist,Str,Rest):-
	lookup(Str,SubStr,Cat,Hist),
	parse1(Cat,Hist,MCat,MHist,SubStr,Rest).

parse1(Cat,H,Cat,H,Str,Str).
parse1(LCat,LHist,GCat,GHist,Str,Rest):-
	psr(LCat,RCat,MCat,RN),
	parse0(RCat,RHist,Str,SubStr),
	parse1(MCat,t(t(MCat,RN,[]),LHist,RHist),GCat,GHist,SubStr,Rest).

%%%  phrase structure rules
%%%     psr(LeftCat,RightCat,MotherCat,Type)
psr({head/H, sc/[RH|PSC],ph/LP},
    {head/RH,sc/[],ph/RP},     
    {sc/PSC,head/H,ph/PP},
    1):-append(LP,RP,PP).

psr({head/RH,sc/[],      ph/LP},
    {head/H,sc/[RH|PSC],ph/RP},
    {sc/PSC,head/H,ph/PP},
    2):-append(LP,RP,PP).

%%%	dictionary
%%%  	lookup(Str,RestStr,Cat,History)
lookup([Word|X],X,{ph/[Word],head/Cat,sc/SC},t(Cat,[Word],[]))
	:-dict(Word,Cat,SC).

dict(mary, noun, []).
dict(john, noun, []).
dict(girl, noun, [determiner]).
dict(girl, noun, [adjective]).
dict(nice,adjective,[]).
dict(pretty,adjective,[]).
dict(the,determiner,[]).
dict(laughs,verb,[noun]).
dict(meets,verb,[noun,noun]).
dict(kisses,verb,[noun,noun]).
dict(embarrasses,verb,[noun,noun]).
dict(thinks,verb,[verb,noun]).
dict(is,verb,[adjective,noun]).
dict(is,verb,[noun,noun]).
dict(met,adjective,[]).
dict(kissed,adjective,[]).
dict(embarrassed,adjective,[]).
