/* aze_cenc.c 2006/03/08
   Copyright (c) SOFNEC Co., Ltd.
 */
#include "aze_api.h"
#include <stdlib.h>
#ifdef __APPLE__
#include <malloc/malloc.h>
#else
#include <malloc.h>
#endif
#include <string.h>

extern void*
aze_malloc(int size)
{
  return malloc((size_t )size);
}

extern void
aze_free(void* addr)
{
  if (addr != NULL)
    free(addr);
}

extern unsigned char*
aze_new_copy_string(const unsigned char* p)
{
  unsigned char *q;

  q = (unsigned char* )malloc(strlen((char* )p) + 2);
  if (q == 0) return NULL;

  strcpy((char* )q, (char* )p);
  return q;
}

extern unsigned char*
aze_new_copy_string2(const unsigned char* p, int len)
{
  unsigned char *q;

  q = (unsigned char* )malloc(len + 2);
  if (q == 0) return NULL;

  memcpy(q, p, (size_t )len);
  q[len]   = 0;
  q[len+1] = 0;
  return q;
}

// T.Inaba Dummy
extern int
initiate_aze_cenc(Frame *Env)
{
  (void)Env;
  return 0;
}
