:- s_new.

%%%%%%%%%%%%%%%
% hpsg_types %% 
%%%%%%%%%%%%%%%

form<-[bot].
fin_form<-[form].
verb_form<-[form].
終止<-[verb_form,fin_form].
未然<-[verb_form].
case_form<-[fin_form].
が格<-[case_form].
に格<-[case_form].
を格<-[case_form].
の格<-[case_form].

direction<-[bot].
left<-[direction].
right<-[direction].

modified<-[bot]+['MODD':direction,'MODR':bot].

pos<-[bot]+['FORM':form,'MOD':list].
動詞<-[pos].
格助詞<-[pos].
名詞<-[pos].
形容詞<-[pos].

gram_cat<-[bot]+['HEAD':pos,'COMPS':list].
sem_struc<-[bot]+['INDEX':bot,'RESTR':list].

predicate<-[bot]+['PRED_NAME':atom].
pred_arg1<-[predicate]+['ARG1':bot].
pred_arg2<-[pred_arg1]+['ARG2':bot].
pred_arg3<-[pred_arg2]+['ARG3':bot].

head_struc<-[bot]+['HEAD_DTR':bot].
head_comp_struc<-[head_struc]+['COMP_DTR':bot].
right_head_mod_struc<-[head_struc]+['RMOD_DTR':bot].
left_head_mod_struc<-[head_struc]+['LMOD_DTR':bot].

sign<-[bot]+['PHONOLOGY':list,'SYN':gram_cat,'SEM':sem_struc].
phrase<-[sign]+['DTRS':head_struc].
word<-[sign].

%%%%%%%%%%%%%%%%
% hpsg_parser %%
%%%%%%%%%%%%%%%%

parse([X|Rest],Rest,_,Lex):-
	lexicon(X,Lex).
parse(L1,L2,[_|X],Tree):-
	parse(L1,L3,X,T1),
	parse(L3,L2,X,T2),
	principles(T1,T2,Tree).

input_phrase(PHRASE,TREE):-
	parse(PHRASE,[],PHRASE,TREE).

input(SENTENCE,TREE):-
	root_condition(TREE),
	input_phrase(SENTENCE,TREE).

print_sem(SENTENCE):-
	input(SENTENCE,TREE),
	TREE={'SEM':{'INDEX':HSEM,'RESTR':OSEM}},
	fs_writeAVM([HSEM,OSEM]).

 %%%%%
test_sentences(0,[きつね,が,転ぶ]).
test_sentences(1,[きつね,が,山,に,住む]).
test_sentences(2,[きつね,が,とんび,に,おいしい,油揚げ,を,買う]).
test_sentences(3,[きつね,が,とんび,に,油揚げ,を,買わ,ない]).
test_sentences(4,[山,の,きつね,が,とんび,に,きつね,の,油揚げ,を,買う]).
test_sentences(5,[油揚げ,が,とんび,に,取ら,れる]).

test(N,Y):- test_sentences(N,X),input(X,Y),!,fs_writeAVM(Y).

%%%%%%%%%%%%%%%%
%% principles %%
%%%%%%%%%%%%%%%%

head_complement_schema(LEFT,RIGHT,HEAD,COMP,MOTHER):-
	MOTHER={'SYN':{'COMPS':COMPS},'DTRS':{'HEAD_DTR':HEAD,'COMP_DTR':COMP}},
	HEAD={'SYN':{'HEAD':{'FORM':fin_form&},'COMPS':[COMP|COMPS]}},
	LEFT=COMP,
	RIGHT=HEAD.

right_head_modifier_schema(LEFT,RIGHT,HEAD,MOD,MOTHER):-
	MOTHER={'SYN':{'COMPS':COMPS},'DTRS':{'HEAD_DTR':HEAD,'RMOD_DTR':MOD}},
	HEAD={'SYN':{'COMPS':COMPS}},
	MOD={'SYN':{'HEAD':{'MOD':[{'MODD':right&,'MODR':HEAD}]}}},
	RIGHT=HEAD,
	LEFT=MOD.

left_head_modifier_schema(LEFT,RIGHT,HEAD,MOD,MOTHER):-fail.

id_principle(LEFT,RIGHT,HEAD,COMP,MOTHER):-
	head_complement_schema(LEFT,RIGHT,HEAD,COMP,MOTHER).

id_principle(LEFT,RIGHT,HEAD,MOD,MOTHER):-
	right_head_modifier_schema(LEFT,RIGHT,HEAD,MOD,MOTHER).

id_principle(LEFT,RIGHT,HEAD,MOD,MOTHER):-
	left_head_modifier_schema(LEFT,RIGHT,HEAD,MOD,MOTHER).

head_feature_principle(HEAD,MOTHER):-
	MOTHER={'SYN':{'HEAD':X}},
	HEAD={'SYN':{'HEAD':X}}.

phonology_principle(LEFT,RIGHT,MOTHER):-
	LEFT={'PHONOLOGY':X},
	RIGHT={'PHONOLOGY':Y},
	MOTHER={'PHONOLOGY':Z},
	append(X,Y,Z).

semantic_compositionality_principle(LEFT,RIGHT,MOTHER):-
	LEFT={'SEM':{'RESTR':LSEM}},
	RIGHT={'SEM':{'RESTR':RSEM}},
	MOTHER={'SEM':{'RESTR':MSEM}},
	append(LSEM,RSEM,MSEM).

semantic_inheritance_principle(HEAD,MOTHER):-
	HEAD={'SEM':{'INDEX':I}},
	MOTHER={'SEM':{'INDEX':I}}.

principles(LEFT,RIGHT,MOTHER):-
	id_principle(LEFT,RIGHT,HEAD,_,MOTHER),
	phonology_principle(LEFT,RIGHT,MOTHER),
	head_feature_principle(HEAD,MOTHER),
	semantic_compositionality_principle(LEFT,RIGHT,MOTHER),
	semantic_inheritance_principle(HEAD,MOTHER).

root_condition({'SYN':{'HEAD':動詞&{'FORM':fin_form&},'COMPS':[]}}).

%%%%%%%%%%%%%
%% Lexicon %%
%%%%%%%%%%%%%

noun_phrase({'SYN':{'HEAD':名詞&{'MOD':[]},'COMPS':[]},
	     'SEM':{'INDEX':SEM} },SEM).

lexicon(きつね,
	word&
	{'PHONOLOGY':[きつね],
	 'SYN':{'HEAD':名詞&{'MOD':[]},'COMPS':[]},
	 'SEM':{'INDEX':きつね,'RESTR':[]}}).

lexicon(山,
	word&
	{'PHONOLOGY':[山],
	 'SYN':{'HEAD':名詞&{'MOD':[]},'COMPS':[]},
	 'SEM':{'INDEX':山,'RESTR':[]}}).

lexicon(とんび,
	word&
	{'PHONOLOGY':[とんび],
	 'SYN':{'HEAD':名詞&{'MOD':[]},'COMPS':[]},
	 'SEM':{'INDEX':とんび,'RESTR':[]}}).

lexicon(油揚げ,
	word&
	{'PHONOLOGY':[油揚げ],
	 'SYN':{'HEAD':名詞&{'MOD':[]},'COMPS':[]},
	 'SEM':{'INDEX':油揚げ,'RESTR':[]}}).

lexicon(に,
	word&
	{'PHONOLOGY':[に],
	 'SYN':{'HEAD':格助詞&{'FORM':に格&,'MOD':[]},'COMPS':[NP]},
	 'SEM':{'INDEX':A,'RESTR':[]}}):-noun_phrase(NP,A).

lexicon(が,
	word&
	{'PHONOLOGY':[が],
	 'SYN':{'HEAD':格助詞&{'FORM':が格&,'MOD':[]},
		'COMPS':[NP]},
	 'SEM':{'INDEX':A,'RESTR':[]}}):-noun_phrase(NP,A).

lexicon(を,
	word&
	{'PHONOLOGY':[を],
	 'SYN':{'HEAD':格助詞&{'FORM':を格&,'MOD':[]},
		'COMPS':[NP]},
	 'SEM':{'INDEX':A,'RESTR':[]}}) :-noun_phrase(NP,A).

lexicon(おいしい,
	word&
	{'PHONOLOGY':[おいしい],
	 'SYN':{'HEAD':形容詞&{'MOD':
	  		[{ 'MODD':right&,
			   'MODR':{'SYN':{'HEAD':名詞&_},
                                   'SEM':{'INDEX':A}}} ] },
		'COMPS':[]},
	 'SEM':{'INDEX':A,'RESTR':[{'INDEX':{'PRED_NAME':おいしい,'ARG1':A}}]}
	}).

%	 'SYN':{'HEAD':形容詞&{'MOD':[{'MODD':right&,'MODR':{'SYN':{'HEAD':名詞&},'SEM':{'INDEX':A}}}]},

lexicon(転ぶ,
    word&{'PHONOLOGY':[転ぶ],
          'SYN':{'HEAD':動詞&{'FORM':終止&,'MOD':[]},
                 'COMPS':[{'SYN':{'HEAD':格助詞&{'FORM':が格&}},'SEM':{'INDEX':A}}]
		 },
	  'SEM':{'INDEX':{'PRED_NAME':転ぶ,'ARG1':A},'RESTR':[]}}).

lexicon(住む,
	word&
	{'PHONOLOGY':[住む],
	 'SYN':{'HEAD':動詞&{'FORM':終止&,'MOD':[]},
		'COMPS':[{'SYN':{'HEAD':格助詞&{'FORM':に格&}},'SEM':{'INDEX':A}},
			 {'SYN':{'HEAD':格助詞&{'FORM':が格&}},'SEM':{'INDEX':B}}]
	       },
	 'SEM':{'INDEX':{'PRED_NAME':住む,'ARG1':B,'ARG2':A},'RESTR':[]}}).

lexicon(買う,
	word&
	{'PHONOLOGY':[買う],
	 'SYN':{'HEAD':動詞&{'FORM':終止&,'MOD':[]},
		'COMPS':[{'SYN':{'HEAD':格助詞&{'FORM':を格&}},'SEM':{'INDEX':A}},
			 {'SYN':{'HEAD':格助詞&{'FORM':に格&}},'SEM':{'INDEX':B}},
			 {'SYN':{'HEAD':格助詞&{'FORM':が格&}},'SEM':{'INDEX':C}}]},
	 'SEM':{'INDEX':{'PRED_NAME':買う,'ARG1':C,'ARG2':B,'ARG3':A},'RESTR':[]}}).

lexicon(買わ,
	word&
	{'PHONOLOGY':[買わ],
	'SYN':{'HEAD':動詞&{'FORM':未然&,'MOD':[]},
	       'COMPS':[{'SYN':{'HEAD':格助詞&{'FORM':を格&}},'SEM':{'INDEX':A}},
			{'SYN':{'HEAD':格助詞&{'FORM':に格&}},'SEM':{'INDEX':B}},
			{'SYN':{'HEAD':格助詞&{'FORM':が格&}},'SEM':{'INDEX':C}}]},
	'SEM':{'INDEX':{'PRED_NAME':買う,'ARG1':C,'ARG2':B,'ARG3':A},'RESTR':[]}}).

lexicon(取る,
	word&
	{'PHONOLOGY':[取る],
	 'SYN':{'HEAD':動詞&{'FORM':終止&,'MOD':[]},
		'COMPS':[{'SYN':{'HEAD':格助詞&{'FORM':を格&}},'SEM':{'INDEX':A}},
			 {'SYN':{'HEAD':格助詞&{'FORM':が格&}},'SEM':{'INDEX':B}}]},
	 'SEM':{'INDEX':{'PRED_NAME':取る,'ARG1':B,'ARG2':A},'RESTR':[]}}).

lexicon(取ら,
	word&
	{'PHONOLOGY':[取ら],
	 'SYN':{'HEAD':動詞&{'FORM':未然&,'MOD':[]},
		'COMPS':[{'SYN':{'HEAD':格助詞&{'FORM':を格&}},'SEM':{'INDEX':A}},
			 {'SYN':{'HEAD':格助詞&{'FORM':が格&}},'SEM':{'INDEX':B}}]},
	 'SEM':{'INDEX':{'PRED_NAME':取る,'ARG1':B,'ARG2':A},'RESTR':[]}}).

lexicon(取ら,
	word&
	{'PHONOLOGY':[取ら],
	 'SYN':{'HEAD':動詞&{'FORM':未然&,'MOD':[]},
		'COMPS':[{'SYN':{'HEAD':格助詞&{'FORM':に格&}},'SEM':{'INDEX':A}},
			 {'SYN':{'HEAD':格助詞&{'FORM':が格&}},'SEM':{'INDEX':B}}]},
	 'SEM':{'INDEX':{'PRED_NAME':取る,'ARG1':B,'ARG2':A},'RESTR':[]}}).

lexicon(ない,
	word&
	{'PHONOLOGY':[ない],
	 'SYN':{'HEAD':動詞&{'FORM':終止&,'MOD':[]},
		'COMPS':[{'SYN':{'HEAD':動詞&{'FORM':未然&},'COMPS':COMPS},'SEM':{'INDEX':A}}
			 |COMPS]},
	 'SEM':{'INDEX':A,'RESTR':[{'INDEX':{'PRED_NAME':否定,'ARG1':A}}]}}).

lexicon(れる,
	word&
	{'PHONOLOGY':[れる],
	 'SYN':{'HEAD':動詞&{'FORM':終止&,'MOD':[]},
		'COMPS':[{'SYN':{'HEAD':動詞&{'FORM':未然&},'COMPS':COMPS},'SEM':{'INDEX':A}}
			 |COMPS]},
	 'SEM':{'INDEX':A,'RESTR':[{'INDEX':{'PRED_NAME':受身,'ARG1':A}}]}}).

