/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */
/* %%%%      SETOF.PL                          %%%% */
/* %%%%                                	       %%%% */
/* %%%% Bagofは取れてきた順に全ての解を出力    %%%% */
/* %%%%  ?- bagof(A,queen(6,A),L).             %%%% */
/* %%%%  L = [[2,4,1,3,5],  ...[4,2,5,3,1]]    %%%% */
/* %%%%                                	       %%%% */
/* %%%% SetOfはソートし同一解を削除して出力    %%%% */
/* %%%%  ?- setof(A,queen(6,A),L).             %%%% */
/* %%%%  L = [[1,3,5,2,4], ...[5,3,1,4,2]]     %%%% */
/* %%%%                                	       %%%% */
/* %%%%自由変数(第一引数に不指定の変数)は　    %%%% */
/* %%%% 自由変数ごとに解の一覧を出力           %%%% */
/* %%%%                                	       %%%% */
/* %%%%  a(a,1).  a(a,2).  a(b,3).  a(b,4).    %%%% */
/* %%%%  ?-bagof(Y,a(X,Y),L).                  %%%% */
/* %%%%  X =  a,                               %%%% */
/* %%%%  L =  [1,2];                           %%%% */
/* %%%%  X =  b,                               %%%% */
/* %%%%  L =  [3,4];                           %%%% */
/* %%%% no                             	       %%%% */
/* %%%%                                	       %%%% */
/* %%%% 自由変数を無視して解をとるには "＾"    %%%% */
/* %%%%  ?-bagof(Y,X^a(X,Y),L).                %%%% */
/* %%%%  L =  [1,2,3,4];                       %%%% */
/* %%%% no                             	       %%%% */
/* %%%%                                	       %%%% */
/* %%%%  ?-bagof(X,(A,B,C)^a(X,A,B,C),L).      %%%% */
/* %%%%                                	       %%%% */
/* %%%% setofはデフォルトで昇順。指定も可能    %%%% */
/* %%%%                                	       %%%% */
/* %%%% setof(X,a(X),L,asc). 　　　　　 　　   %%%% */
/* %%%% setof(X,a(X),L,dec).　　　　　　　   　%%%% */
/* %%%%                                	       %%%% */
/* %%%% == 2014.3.28 制約対応bagof ==          %%%% */
/* %%%% a(X):-freeze(X,X>1),X in 0..9.         %%%% */
/* %%%% a(X):-freeze(X,X<1).                   %%%% */
/* %%%% ?- f_bagof(X,a(X),[A,B]),frozen(A,AL). %%%% */   
/* %%%% A =  _14 {[0..9]::X>1,!}               %%%% */
/* %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% */

:- s_mode(_,on).

:- public setof/4.
:- public setof/3.
:- public bagof/3.
:- public ^ / 2.
:- public s_qsort/3.
:- public findall/3.

/* 2014.3.28 Added */
:- public f_bagof/3.
:- public f_findall/3.
:- public f_setof/4.
:- public f_setof/3.
:- public f_assert/1.
:- public f_assertz/1.

f_assert(Term):-  ff_goal(Term,NewTerm),assert(NewTerm).
f_assertz(Term):- ff_goal(Term,NewTerm),assertz(NewTerm).

ff_goal((Head:-Goal),(Head:-NewGoal)):-!,f_goal((Head:-Goal),[],_,NewGoal,Goal).
ff_goal(Head,(Head:-NewGoal)):-f_goal(Head,[],_,Goal,!),f_rm(Goal,NewGoal),!.
ff_goal(Head,Head).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
_ ^ X :- X.

setof(X,G,L):-setof(X,G,L,asc).

setof(X,G,L,Sort):-(Sort==asc;Sort==dec),!,bagof(X,G,L1),s_qsort(Sort,L1,[],L).
bagof(X,G,L):-s_freevar(X,G,V),findall([X|V],G,L1),s_result(V,L1,L).

s_result(V,[[X|W]|L],R):-s_result1(W,L,R1,L1),s_result2(V,W,[X|R1],L1,R).

s_result1(_,[],[],[]):-!.
s_result1(V,[[X|V]|L1],[X|L2],L3):-!,s_result1(V,L1,L2,L3).
s_result1(V,[Y|L1],L2,[Y|L3]):-s_result1(V,L1,L2,L3).

s_result2(V,V,R,_,R).
s_result2(V,_,_,L,R):-s_result(V,L,R).

findall(X,G,_):-asserta(s_found(s_mark)),call(G),asserta(s_found(X)),fail.
findall(_,_,L):-s_collect([],M),!,L=M.

s_collect(S,L):-s_getnext(X),!,s_collect([X|S],L).
s_collect(L,L).

s_getnext(X):-retract(s_found(X)),!,X\==s_mark.

s_freevar(X,G,V):-s_freevar1(X,[],[],L),s_freevar1(G,L,[],V).

s_freevar1(X,_,L2,L2):-atomic(X),!.
s_freevar1(X,L1,L2,L2):-var(X),s_member(X,L1),!.
s_freevar1(X,L1,L2,[X|L2]):-var(X),!.
s_freevar1([X|L],L1,L2,L3):-!,s_freevar1(X,L1,L2,L4),s_freevar1(L,L1,L4,L3).
s_freevar1(X ^ Y,L1,L2,L3):-!,s_freevar1(X,L1,L1,L4),s_freevar1(Y,L4,L2,L3).
s_freevar1(TM,L1,L2,L3):-TM=..[_|L],s_freevar1(L,L1,L2,L3).

s_member(X,[A|L]):-X==A,!.
s_member(X,[_|L]):-s_member(X,L).


s_qsort(S,L,L2):-s_qsort(S,L,[],L2).

s_qsort(S,[],L1,L1):-!.
s_qsort(S,[X|L],L1,L2):-s_partition(S,X,L,L3,L4),s_qsort(S,L4,L1,L5),
		s_qsort(S,L3,[X|L5],L2).

s_partition(_,X,[],[],[]):-!.
s_partition(asc,X,[A|L],L1,[A|L2]):-X@<A,!,s_partition(asc,X,L,L1,L2).
s_partition(dec,X,[A|L],L1,[A|L2]):-X@>A,!,s_partition(dec,X,L,L1,L2).
s_partition(S,X,[A|L],L1,L2):-X==A,!,s_partition(S,X,L,L1,L2).
s_partition(S,X,[A|L],[A|L1],L2):-s_partition(S,X,L,L1,L2).


%%%%%%%%% 2014.3.28 Added %%%%%%%%%%%%%%%
f_setof(X,G,L):-f_setof(X,G,L,asc).
f_setof(X,G,L,Sort):-
	(Sort==asc;Sort==dec),!,f_bagof(X,G,L1),s_qsort(Sort,L1,[],L).

f_bagof(X,G,L):- s_freevar(X,G,V),f_findall([X|V],G,L1),s_result(V,L1,L).

%%%%%%
f_findall(X,G0,_):-
        (G0 = _^ G -> true;G0=G),
        asserta(s_found(s_mark)),
                call(G),
                f_goal(G,[],_,Frozen, ! ),
                asserta(s_found([X,Frozen])),
        fail.
f_findall(_,_,L):- f_collect([],M),!,L=M.

%%%%%%
f_collect(S,L):- s_getnext(XG),XG=[X,F],call(F),!,f_collect([X|S],L).
f_collect(L,L).

%%%%%%
f_goal(X,L2,L2,G,G):- atomic(X),!.
f_goal(X,L,L,G,G):- var(X),s_member(X,L),!.
f_goal(X,L,[X|L],Goal,S):- var(X),!,f_check_clp(X,Goal,S).
f_goal([X|L],L1,L3,G,G2):- !,f_goal(X,L1,L2,G,G1),f_goal(L,L2,L3,G1,G2).
f_goal(TM,L1,L2,G1,G2):- TM=..[_|L],f_goal(L,L1,L2,G1,G2).

f_check_clp(X,(freeze(X,G),ST),S):-frozen(X,F),f_rm(F,G),!,f_clp_area(X,ST,S).
f_check_clp(X,G,S):- f_clp_area(X,G,S).

f_clp_area(X,(put_clp_area(X,L),S),S):- get_clp_area(X,L),!.
f_clp_area(X,S,S).

f_rm(','(A,!),A):-!.
f_rm(','(A,B),','(A,C)):- f_rm(B,C).

:- s_mode(_,off).

