/*
大容量スタックテストプログラム T.Inaba 2009.8.10

>prolog -g 600000 -s ack.pl   % 物理メモリが１２Ｇ程度実装されているばあい、グローバルスタックが６００Ｍセル程度とれる

| ?- test.

*/

:- publicall.

test:- repeat(N),
         T is cputime,
              ack3(3,N,Ans),
         Te is cputime-T,
         write(ack(3,N)=Ans),tab(2),write(Te=seconds),nl,
       fail.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/*
アッカーマン関数
ack(0 , y) = y +1
ack(x , 0) = ack (x−1 , 1)　… ｛ｘ≠０｝
ack(x , y) = ack (x−1 , ack(x , y−1))　…｛ｘ≠０, ｙ≠０｝ 
*/

:- mode ack(integer,integer,-).
ack(0,Y,Ans):-!,Ans is Y+1.
ack(X,0,Ans):-!,XX is X-1,ack(XX,1,Ans).
ack(X,Y,Ans):-XX is X-1,YY is Y-1,ack(X,YY,A),ack(XX,A,Ans).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% スタックを用いて二重再帰を除去
ack2(X,Y,Ans):- ack2(X,Y,[],Ans).

:-mode ack2(integer,integer,list,-).

ack2(0,Y,[],Ans):-!,Ans is Y+1.
ack2(0,Y,[X|S],Ans):-!,YY is Y+1,ack2(X,YY,S,Ans).
ack2(X,0,S,Ans):-!,XX is X-1,ack2(XX,1,S,Ans).
ack2(X,Y,S,Ans):-XX is X-1,YY is Y-1,ack2(X,YY,[XX|S],Ans).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% スタックに０を積まないように細工

ack3(X,Y,Ans):- ack3(X,Y,[],Ans).

:-mode ack3(integer,integer,list,-).

ack3(0,Y,[],Ans):-!,Ans is Y+1.
ack3(0,Y,[X|S],Ans):-!,YY is Y+1,ack3(X,YY,S,Ans).
ack3(1,Y,[X|S],Ans):- !,YY is Y+2,ack3(X,YY,S,Ans).       %% 細工!
ack3(X,0,S,Ans):-!,XX is X-1,ack3(XX,1,S,Ans).
ack3(X,Y,S,Ans):-XX is X-1,YY is Y-1,ack3(X,YY,[XX|S],Ans).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% n番目のフィボナッチ数F(n)は次のように定義される。
%
%  F(0) = 0  
%  F(1) = 1
%  F(n+2) = F(n+1) + F(n)    （ｎは正の整数）
%
%                                    fibo(5)
%                                      |
%                      fibo(4)---------+-------------------fibo(3)
%                        |                                   |
%             fibo(3)----+-------fibo(2)            fibo(2)--+--fibo(1)
%               |                  |                  |
%       fibo(2)-+-fibo(1)  fibo(1)-+-fibo(0)  fibo(1)-+-fibo(0)
%         |
% fibo(1)-+-fibo(0)
%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 定義どおりにプログラムするとこうなる

fibo(N,X):- N>=2,!,N1 is N-1,N2 is N-2,fibo(N1,X1),fibo(N2,X2),X is X1+X2.
fibo(N,N):- N>=0.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% これでは２重再帰のうえ、末尾呼び出しの最適化もおこなわれないので
% スタックを用いて２重再帰を除去し、中間結果を保持するレジスタを用意し
% 末尾呼び出し最適化をおこなえるように改造することができる。

fibo1(N,X):- N>=0,fibo2(N,[],0,X).

fibo2(N,S,R,X):- N>=2,!,N1 is N-1,N2 is N-2,fibo2(N1,[N2|S],R,X).
fibo2(N,[M|S],R,X):- !,R2 is R+N,fibo2(M,S,R2,X).
fibo2(N,[],R,X):-X is R+N.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% プログラムをよく見ると、同じ値での計算を延々と繰り返しており、最左辺の
% 計算結果を保持してさえいれば、再計算する必要がない。 (メモ）

fibo0(N,X):- '$fibo$'(N,X),!.
fibo0(N,X):- N>=2,!,N1 is N-1,N2 is N-2,fibo0(N1,X1),fibo0(N2,X2),X is X1+X2,asserta('$fibo$'(N,X)).
fibo0(N,N):- N>=0.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% さらに仔細に検討すると、計算値は一つ前のものだけ保持しておればよい。

fibox(N,X):- N>=0,fibox(N,_,X).

fibox(N,X,Ans):- N>=2,!,N1 is N-1,fibox(N1,B,X),Ans is B+X.
fibox(N,0,N):- N>=0.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% レジスタを用いて末尾最適化をはかりローカルスタックを消費しないプログラムに変換できる。

fiboy(N,X):- N>=0,fiboy(N,B,Ans),X is Ans.

fiboy(N,X,B+X):- N>=2,!,N1 is N-1,fiboy(N1,B,X).
fiboy(N,0,N):- N>=0.

%%% トレースなどデバッグ機能を使うときは次の一行をコメントアウトして再立ち上げしてください
:- compile_all.
