/*
     SUDOKU SOLVER   2013.11.24  T.Inaba(SOFNEC.CO.LTD)
 | ?- go(PatterNo).    % PatternNo 1-4 : 9x9     5 : 25x25
*/ 

:- dlib_require(clp).

go:- go(1),go(2),go(3),go(4),go(5).

go(No):- 
  sudoku_pattern(No,Horizontal),!,
  get_vars(Horizontal,Vertical,Box,Write,Length,VL),
    statistics(runtime,[Begin,_]),
	mapcar(in,           Horizontal, [1..Length]),
	mapcar(alldifferent, Horizontal, []),
	mapcar(alldifferent, Vertical,   []),
	mapcar(alldifferent, Box,        []),
	mapcar(labeling,     Horizontal, []),
    statistics(runtime,[End,_]),
  Time is End-Begin,
  verify(VL,Horizontal,Vertical,Box,Verify),
  mapcar(write,['No.',No,' ',Length,x,Length,' ',Time,'',msec,Verify|Write],[]).

%%%% map call
mapcar(Func,[Arg1|R],Arg2):- !,G=..[Func,Arg1|Arg2],call(G),mapcar(Func,R,Arg2).
mapcar(_,   [],_).

%%%% result verify
verify(L,H,V,B,' Verify OK!'):-
	mapcar(sort,H,L),mapcar(sort,V,L),mapcar(sort,B,L),!.
verify(_,_,_,_,' Verify NG!').

%%% End Of Main Program %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%% 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Making Var List For Constraint if not created 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
/*
?- get_vars(Horizontal,Vertical,Box,Write,4,VerifyL).

Horizontal = [[X1, X2,  X3, X4],     % in 1..4,alldifferent
              [X5, X6,  X7, X8],     % in 1..4,alldifferent
              [X9, X10, X11,X12],    % in 1..4,alldifferent
              [X13,X14, X15,X16]]    % in 1..4,alldifferent

Vertical   = [[X1,X5,X9,X13],        % alldifferent
              [X2,X6,X10,X14],       % alldifferent
              [X3,X7,X11,X15],       % alldifferent
              [X4,X8,X12,X16]]       % alldifferent

Box        = [[X1,X2,X5,X6],         % alldifferent
              [X3,X4,X7,X8],         % alldifferent
              [X9,X10,X13,X14],      % alldifferent
              [X11,X12,X15,X16]]     % alldifferent

Write      = [[X1,X2],  ' ',[X3,X4],'
',            [X5,X6],  ' ',[X7,X8],'
','
',            [X9,X10], ' ',[X11,X12],'
',            [X13,X14],' ',[X15,X16],'
','
']

VerifyL    = [[1,2,3,4]]

*/

:- dynamic sudoku_vars/6.              % dummy for contorol unknown ERROR!
get_vars(H,V,B,W,Length,VL):-             % Created !
	sudoku_vars(H,V,B,W,Length,VL),!.
get_vars(HH,V,B,W,Length,VL):-             % Not Created Yet! 
  	length(HH,Length),
  	S is integer(sqrt(Length)),
	   make_h(Length,Length,H,[],VL),
	   make_v(H,V),
	   make_b(S,H,B),
	   make_w(NL,H,S,S,W),
	asserta(sudoku_vars(H,V,B,W,Length,VL)),
	H=HH.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Making Horizontal vars List
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
make_h(_,0,[],   VL,[VL]):-!.
make_h(N,M,[B|H],VL,VLR):- make_h2(N,B),MM is M-1, make_h(N,MM,H,[M|VL],VLR).
  %%
make_h2(0,[]):-!.
make_h2(N,[X|B]):- M is N-1,make_h2(M,B).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Horizontal  ==> Vertical vars
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
make_v([[]|_],[]):-!.
make_v(H,     [B|V]):-make_v2(H,B-B,NextH),make_v(NextH,V).
  %%
make_v2([],       _-[],   []):-!.
make_v2([[X|Q]|H],B-[X|T],[Q|NextH]):- make_v2(H,B-T,NextH).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Horizontal ==> Box vars List
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
make_b(_,[],[]):- !.
make_b(S,[[]|L],Ans):-!,make_b(S,L,Ans).                % delete Null EOL
make_b(S,H,     [B|Ans]):-make_b2(S,S,S,H,B-B,NextH),make_b(S,NextH,Ans).
  %%
make_b2(_,1,0,NextH,    _-[],   NextH):-!.                           % EndOfBox
make_b2(S,M,0,[Q|H],    B,      [Q|R]):-!,N is M-1,make_b2(S,N,S,H,B,R).  % EOL
make_b2(S,M,C,[[X|Q]|H],B-[X|T],NextH):-D is C-1,make_b2(S,M,D,[Q|H],B-T,NextH).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Horizontal ==> write Goal
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
make_w(Z,H,    S,0,[Z|R]):-!,make_w(Z,H,S,S,R).
make_w(Z,[B|H],S,N,[Z|R]):-!,make_w2(B,S,S,Q-Q,R-T),M is N-1,make_w(Z,H,S,M,T).
make_w(Z,[],   _,_,[Z]):- make_cr(Z).
  %%
make_w2([],   _,_,Q-[],   [Q|R]-R):-!.
make_w2(B,    S,0,Q-[],   [Q,' '|R]-T):-!,make_w2(B,S,S,Y-Y,R-T).
make_w2([X|B],S,N,Q-[X|P],Result):- M is N-1,make_w2(B,S,M,Q-P,Result).
  %%
make_cr('
').

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%% Data Division %%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 %%%%%%%%%%%%%%%%%%%%%
 %%%% Pattern 9x9 %%%%

sudoku_pattern(1,
	[[9,_,_,  _,_,8,  _,_,3],
	 [_,8,_,  1,_,_,  5,_,_],
	 [_,_,_,  _,_,7,  _,1,_],
 
	 [_,4,_,  _,1,_,  _,_,9],
	 [_,_,7,  _,_,_,  4,_,_],
	 [3,_,_,  _,6,_,  _,5,_],

	 [_,3,_,  8,_,_,  _,_,_],
	 [_,_,6,  _,_,3,  _,2,_],
	 [2,_,_,  9,_,_,  _,_,7]]).
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% http://gigazine.net/news/20100822_hardest_sudoku/

sudoku_pattern(2,
	[[_,_,5,  3,_,_,  _,_,_],
	 [8,_,_,  _,_,_,  _,2,_],
	 [_,7,_,  _,1,_,  5,_,_],
 
	 [4,_,_,  _,_,5,  3,_,_],
	 [_,1,_,  _,7,_,  _,_,6],
	 [_,_,3,  2,_,_,  _,8,_],

	 [_,6,_,  5,_,_,  _,_,9],
	 [_,_,4,  _,_,_,  _,3,_],
	 [_,_,_,  _,_,9,  7,_,_]]).

sudoku_pattern(3,
	[[1,2,3,  4,5,6,  7,8,9],
	 [4,5,6,  7,8,9,  1,2,3],
	 [7,8,9,  1,2,3,  4,5,6],
 
	 [2,_,_,  _,_,_,  _,_,_],
	 [_,_,_,  _,_,_,  _,_,_],
	 [_,_,_,  _,_,_,  _,_,_],

	 [_,_,_,  _,_,_,  _,_,_],
	 [_,_,_,  _,_,_,  _,_,_],
	 [_,_,_,  _,_,_,  _,_,_]]).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% http://rocketnews24.com/2012/07/03/22654/

sudoku_pattern(4,
	[[8,_,_,  _,_,_,  _,_,_],
	 [_,_,3,  6,_,_,  _,_,_],
	 [_,7,_,  _,9,_,  2,_,_],
 
	 [_,5,_,  _,_,7,  _,_,_],
	 [_,_,_,  _,4,5,  7,_,_],
	 [_,_,_,  1,_,_,  _,3,_],

	 [_,_,1,  _,_,_,  _,6,8],
	 [_,_,8,  5,_,_,  _,1,_],
	 [_,9,_,  _,_,_,  4,_,_]]).

 %%%%%%%%%%%%%%%%%%%%%%%
 %%%% Pattern 25x25 %%%%

sudoku_pattern(5,
 [[ 2, _, _, _, 6,24, 9,16,20, 3, _, 4,23, _,11,13, _,10,17, _, _,14, _,19, 5],
  [16, 1,22, _, 5,23,19, _, _, _,12, 2, _, _,25,11, _, _, _, 9, _, _,18,21, 6],
  [ _,24, _, _, _, 4, _, 8, _, _,16,19,18, 5, 3, _, _,12, _, 6, _, _, 9, 1,25],
  [11, _,23, _, _,10, _, 1, _,25, 6,17,20, _,13, 4, _, 2,22, _, _, _, _,16,24],
  [ 8, _,13,21, 3, _, 6,18, _,17, _, 9,22, _,14, 1, _, 5, _,25, 7, _, _, _, _],
  [24, _, _, _,15, 7, _, 3,16,20, _, _,21,10, 2, _, 1, _,11, 8,25, _, _, 4, _],
  [25, _, _,23, _,21, _, _, _,19,24, _, 3, 6, _,17, _, _,18,16, 9, 2, _, _, _],
  [ _,21,19, _,10, _, 4, _,15, _, 5,18,25,23,12, _, _,13, _,20,11, _, _,14, _],
  [22,13,20,17, _, 6, _, _,25, _,19,11,14, _, 4, _, 2,21, _,23, _, 8,15, _, _],
  [ _, _, 6, _, _,17,14,13,22, 9, _, _, _,16, _, _, _,25, _, _,24,19, 3,23, _],
  [10, _, 2, 9,11, 8,17, _, _,16, _, _, 7, _, _,22, _, _,13, _, _,25,20,18,15],
  [13, _, _, _,22, _, _,21, _, 1, _, _, _, _,15, _, _, _, _, 5, 2,12, _, _,19],
  [ 1, _,15, 8,14,22,25,23, 7,11, _, 6, 2, _,10, _,20, _,21, _, _,24, 5, _, _],
  [ _,20, _,25, _, 5, _,15,19, 2, _,16,11, _,24, 6, _,18, 8,17,23, 9, _,22, _],
  [21, 6,18,19, _,20,12, _,14, _, _, _,17, _,22, _, _, _, _, 2,16, 7,11, _, 1],
  [ _, _, _, _,17,25, 2,20, _,10, _, _, _, 4, 1, _,12,24, _,15,22, 5, _, _, _],
  [ 5, 2,24, _,25, _, 8,19, _, 7, _,10,12, _, 6, 3, _, 4, _,13, _, _, _, _, _],
  [ 4, 3, _, 6,20, _,15,22, _,21, _,25, 5, 8, _,16, _, _, _,11, _, _,23,12,18],
  [ _,23, 9,10,19, _, _, _, 3, 4, _, _, _,22, _, _, 5, 8, 6, 1, _,13,16, _,11],
  [ _,18, _, _, _, 1, _,11, _,14,13, 7,19, _,20, 2,17,23,10,22, 8, _,24, _, _],
  [ 9, _, _, 1, _, _,20,25, _, 5, _, _, _, 2,16,12, _, _, _, _, 4,15, _,11, 8],
  [ _, _,25, 7, _,15,16, _,17,13,14, _,10,20, _, _, _, 9, 5, _, 1, _,21, 3, 2],
  [23, _, _, 2,12, _, _, _, _, 6, 7, 8, _,19, _,18,21,16,24, _,17, _, _,13, 9],
  [20, 4,14, _,21, _, _, _, _, _,22,15, 6,25, _, _,13, _, _, _, _,16, _, _, 7],
  [ _, 8,16, 3, _, 9,24, _, _,12, _,21, 1,17,23, _, _, _, 2, _, 6,22,14, _,10]]).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Skeleton For New Puzzle %%%

 %%%%%%%%%%%%%%%%%%%%%
 %%%% Pattern 4x4 %%%%
sudoku_pattern(6,
	[[_,1,  _,_],
	 [_,_,  2,_],
 
	 [3,_,  _,_],
	 [_,_,  _,4]]).
 
 %%%%%%%%%%%%%%%%%%%%%
 %%%% Pattern 9x9 %%%%
sudoku_pattern(7,
	[[_,_,_,  _,_,_,  _,_,_],
	 [_,_,_,  _,_,_,  _,_,_],
	 [_,_,_,  _,_,_,  _,_,_],
 
	 [_,_,_,  _,_,_,  _,_,_],
	 [_,_,_,  _,_,_,  _,_,_],
	 [_,_,_,  _,_,_,  _,_,_],

	 [_,_,_,  _,_,_,  _,_,_],
	 [_,_,_,  _,_,_,  _,_,_],
	 [_,_,_,  _,_,_,  _,_,_]]).
 
 %%%%%%%%%%%%%%%%%%%%%%%
 %%%% Pattern 16x16 %%%%
sudoku_pattern(8,
	[[_,_,_,_,  _,_,_,_,  _,_,_,_, _,_,_,_],
	 [_,_,_,_,  _,_,_,_,  _,_,_,_, _,_,_,_],
	 [_,_,_,_,  _,_,_,_,  _,_,_,_, _,_,_,_],
	 [_,_,_,_,  _,_,_,_,  _,_,_,_, _,_,_,_],

	 [_,_,_,_,  _,_,_,_,  _,_,_,_, _,_,_,_],
	 [_,_,_,_,  _,_,_,_,  _,_,_,_, _,_,_,_],
	 [_,_,_,_,  _,_,_,_,  _,_,_,_, _,_,_,_],
	 [_,_,_,_,  _,_,_,_,  _,_,_,_, _,_,_,_],

	 [_,_,_,_,  _,_,_,_,  _,_,_,_, _,_,_,_],
	 [_,_,_,_,  _,_,_,_,  _,_,_,_, _,_,_,_],
	 [_,_,_,_,  _,_,_,_,  _,_,_,_, _,_,_,_],
	 [_,_,_,_,  _,_,_,_,  _,_,_,_, _,_,_,_],

	 [_,_,_,_,  _,_,_,_,  _,_,_,_, _,_,_,_],
	 [_,_,_,_,  _,_,_,_,  _,_,_,_, _,_,_,_],
	 [_,_,_,_,  _,_,_,_,  _,_,_,_, _,_,_,_],
	 [_,_,_,_,  _,_,_,_,  _,_,_,_, _,_,_,_]]).

