/*
   4X4 sudoku with debugging

   Hint is 
      [_,  1,   _,  _,
       _,  _,   2,  _,
       3,  _,   _,  _,
       _,  _,   _,  4], 

  > prolog_c -s sudoku4x4.pl
  
  | ?-trace.
  ||?- go.

  Use "I" command at each trace phase

*/
:- dlib_require(clp).

go:- Vars = [X1, X2,  X3, X4,
             X5, X6,  X7, X8,
             X9, X10, X11,X12,
             X13,X14, X15,X16], 

     %% Individual elements in the Vars must be 1 or 2 or 3 or 4
     Vars in 1..4 ,

     %% Individual elements in the each horizontal line must be different value
     alldifferent([X1, X2,  X3, X4]),
     alldifferent([X5, X6,  X7, X8]),
     alldifferent([X9, X10, X11,X12]),
     alldifferent([X13,X14, X15,X16]), 

     %% Individual elements in the each vertical line must be different value
     alldifferent([X1,X5,X9,X13]),
     alldifferent([X2,X6,X10,X14]),
     alldifferent([X3,X7,X11,X15]),
     alldifferent([X4,X8,X12,X16]),

     %% Individual elements in the each quadrangular must be different value
     alldifferent([X1,X2,X5,X6]),
     alldifferent([X3,X4,X7,X8]),
     alldifferent([X9,X10,X13,X14]),
     alldifferent([X11,X12,X15,X16]),

     %% Unify with Hint
     X2 =1,
     X7 =2,
     X9 =3,
     X16=4,

     %% Find a solution
     labeling(Vars),

     %% Display result
     write([[X1,X2],  [X3,X4]]),nl,
     write([[X5,X6],  [X7,X8]]),nl,nl,
     write([[X9,X10], [X11,X12]]),nl,
     write([[X13,X14],[X15,X16]]),nl.

