:- kanji_mode(_,off).

require(X):- mecab_version(_), !.  % for built-in library case.
require(X):- dlib_require(X), !,
  write('Library Loaded: '), mecab_version(V), write(V), nl.
require(X):- dlib_get_error_str(S), name(E, S), write(E), nl.

:- require(mecab).

t:-
  mecab_version(VERSION),
  test_repeat(100),
  write('Version: '), write(VERSION), nl.

test_repeat(N):-
  repeat(I),
  test_ex,
  I1 is I + 1,
  write('--- REPEAT '), write(I1), write(' END. ---'), nl,
  I1 >= N.

test_ex:-
  test("今日は雪だ。"),
  test("もももすももももものうち。"),
  test_best("もう腹が減ったよ。"),
  test('XZZ News:---マスコミ各社の報道によると、警視庁はタレントのローラさんの父親の逮捕状をとり国際手配したという...'),
  test('有効求人倍率が上昇し、雇用も改善するとの見通しの中、いろいろなところで緩和効果があらわれ、前向きな行動がでてきている。').

test(S):-
    %mecab_new(M, ['azmecab', '-d', '/usr/local/lib/mecab/dic/unidic']),
    %mecab_new(M, ['azmecab', '-d', '/usr/local/lib/mecab/dic/ipadic']),
    %mecab_new(M, ['azmecab', '-r', '/usr/local/etc/mecabrc.ipadic']),
    mecab_new(M, []),
    mecab_sparse_tonode(M, S, 12, NODE_LIST),
    write_node_list(NODE_LIST),
    mecab_destroy(M).

write_node_list([]).
write_node_list([H|T]):-
  display(H), nl,
  write_node_list(T).


test_best(S):-
    mecab_new(M, ['azmecab', '-N10', '-l1']),
    err_check_mecab_nbest_init(M, S),
    write_nbest_all(M, 2),
    mecab_destroy(M).

err_check_mecab_nbest_init(M, S):-
    mecab_nbest_init(M, S), !.
err_check_mecab_nbest_init(M, S):-
    mecab_strerror(M, ES),
    write(ES), nl,
    fail.

write_nbest_all(M, MAX):- write_nbest_all(M, MAX, 0).

write_nbest_all(M, MAX, N):-
    N < MAX,
    NP is N + 1,
    mecab_nbest_next_tonode(M, 3, NODE_LIST), !,
    write(NP), nl,
    write_node_list(NODE_LIST),
    write_nbest_all(M, MAX, NP).
write_nbest_all(M, MAX, N):- mecab_nbest_end.


%%
ts:-
  mecab_version(VERSION),
  ts_repeat(100),
  write('Version: '), write(VERSION), nl.

ts_repeat(N):-
  mecab_new(M, []),
  repeat(I),
  ts_ex(M),
  I1 is I + 1,
  write('--- REPEAT '), write(I1), write(' END. ---'), nl,
  I1 >= N,
  mecab_destroy(M).

ts_ex(M):-
  ts1(M, "今日は雪だ。"),
  ts1(M, "ＡＩＪ投資顧問（現ＭＡＲＵ）による詐欺事件で、詐欺と金融商品取引法違反（契約に関する偽計）に問われた同社前社長・浅川和彦被告（６１）ら３人の公判が２日、東京地裁（安東章裁判長）であり、検察側は浅川被告に懲役１５年、３人から計約２１８億円を追徴するよう求刑した。"),
  ts1(M, "エジプトのモルシ大統領は2日、政治混乱を3日までに収拾しなければ政治介入を行うとした軍の最後通告について、受け入れない考えを表明した。"),
  ts1(M, "互いに素（たがいにそ、英: coprime）は、二つの整数が 1 と -1 以外に共通の約数を持たない場合の二数の関係である。").

ts1(M, S):-
  mecab_sparse_tostr(M, S, RS),
  wlist(RS).


wlist([]):- !.
wlist([H|T]):- put(H), wlist(T).

%%
%:- t.
