#!/usr/local/bin/prologcgi

:-s_charset(_,utf8).
top_call:-
    (get_param(num,N),integer(N),N=<100,0 is N mod 2 -> true;N=40),M is N//2,
    (get_param(p,X),integer(X),X>=0,X=<N -> true;X=N),XX is X-1,
    html_call(["Content-Type: text/html; charset=utf-8",call((nl,nl)),
     "<html><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'></head>
      <body><center><H1>対戦表生成(2)　　<INPUT TYPE='button' VALUE='RETURN' onClick='history.back()'></H1>
       <H3>番号１から番号ＮまでのＮ人(偶数)の棋士が総当り戦の勝数で順位を決めることになりました。<br>
           全員が同時に対戦できるようＮ/２面の将棋盤を用意したとして、対戦表を生成します。<br>
           （サーバ負荷軽減のため100以下の偶数を入力して下さい）</H3>
           <form action='Nbattle3.cgi' method='POST'>
            Ｎ＝<input type='text' name='num' value='",N,"' size='3'>
            <input type='submit' value='生成'>
           </form>
           <button onclick=window.location.href='Nbattle3.cgi?num=",N,"&p=",XX,"'>別解</button><br><br>",
          call((X=0->write('<H2>Done!</H2>');a_go(N,X,L), w_html('盤No',M,disp1(1,L,0'20202)), w_html('',N,disp2(N)))),
     "</center></body></html>"]).

%%%%%% 解の生成 (参考 http://sankei.jp.msn.com/science/science/081104/scn0811040809001-n1.htm) %%%%%
a_go(N,X,Ans):- 
    M is N-1,S is (N-2)//2,                  % M=円周の回転シフト回数,S=対象線の本数（先頭と中心を除いた組数）
    a_gen(N,X,L,L),                         % 1からN-1までのリスト（円周に配置する番号リスト）
    a_get_all(M,S,X,L,Ans).                 % 解の生成

%% 1からN-1 までの番号リストを生成する
a_gen(0,_,X,X):-!.                            % 循環リストにしておくのがミソ
a_gen(M,M,L,T):- !,MM is M-1,a_gen(MM,M,L,T).
a_gen(M,X,[M|L],T):- MM is M-1,a_gen(MM,X,L,T).

%% 全シフトした解の生成
a_get_all(0,_,_,_,[]):-!.                   % 所定回数の回転シフトが終わった
a_get_all(M,S,N,[A|L],[[A-N|X]|R]):-        % [リスト先頭-N|対象組１セット]
    a_get_one(S,L,X,_),                     % 対象組１セット取得
    MM is M-1,a_get_all(MM,S,N,L,R).        % シフト回数減、円周リストをシフト

%% １セット分の取得とリストのシフト
a_get_one(0,L,[],L):-!.                     % 半分を処理したら残りを折り返す
a_get_one(S,[A|L],[A-X|R],T):-              % 先頭要素と組になる値を変数としておく
    SS is S-1,a_get_one(SS,L,R,[X|T]).      % Xの値設定のために反転リストを生成

%%%%%%% 表の出力 %%%%%%%%%
w_html(T,N,G):- 
   write('<table border="1"><tr><td></td>'),
      repeat(S),S>0,w_td('','lavender','',T,S),S==N,!,w_tr,call(G),
   write('</table><br>'),nl.

disp1(_,[],_):-!.
disp1(N,[A-B|L],Z):- !,my_sort(A,B,C,D),assert((tbl(C,D,N,Z):-!)),w_td('','','',C-D,''),disp1(N,L,Z).
disp1(N,[A|L],E):- S is N*E,w_td('<tr>',S,white,N,'日目'),disp1(N,A,S),w_tr, M is N+1,disp1(M,L,E).

disp2(E):- 
    assertz(tbl(_,_,□,'')),
    repeat(N),N>0,
       w_td('<tr>','lavender','',N,''),(repeat(C),C>0,tbl(N,C,No,S),w_td('',S,white,No,''),C==E,!),w_tr,
    N==E,!.

w_td(A,B,C,D,E):- write_list([A,'<td bgcolor="',B,'"><font color="',C,'">',D,E,'</font></td>']).
w_tr:-write('</tr>'),nl.

my_sort(A,B,A,B):- A<B,!.
my_sort(A,B,B,A).


