/* ?- renames('').
	SYSTEM  ==> system
	ISO_PRED.PL ==> iso_pred.pl
*/
renames:- renames('.c'),renames('.h'),renames('.pl').

renames(Ex):-
	atom_append('ls *',Ex,Cmd),
	s_child(bash,['-c',Cmd],I,OutS,P),
	repeat,
		get_chars(OutS,31,Status,Data),
		make_new_name_if(Data,Status),
	!,seen(OutS),told(I).

get_chars(S,End,Status,Data):-
	get0(S,D),get_chars(S,D,End,Status,Data).

get_chars(S,4,_,end,[]):-!.
get_chars(S,D,D,cont,[]):-!.
get_chars(S,D,E,St,[D|L]):-get0(S,ND),get_chars(S,ND,E,St,L).

make_new_name_if(_,end):-!.
make_new_name_if(Data,_):-
	make_new_name(Data,NewData),
	name(DA,Data),
	name(NewDA,NewData),
	write((DA-->NewDA)),nl,
	rename(DA,NewDA),
	fail.

make_new_name([],[]):-!.
make_new_name([A|L],[B|R]):-
	e_lower(A,B),make_new_name(L,R).

