demand:- 
	write('Five people will sit down on a round table with five chairs'),nl,
	write('The name of five people is Andrew,Carol,Jessica,Luke,Tommy'),nl,
	write('However, they have a demand at one''s seat'),nl,
	write('Find all solutions'),nl,nl,

	write('   A'),nl,
	write(' B @ E   ===> Seat refers [A,B,C,D,E] '),nl,
	write('  C D'),nl,nl,

	write('<1> Carol wants to sit at the C seat.'),nl,
	write('<2> Andrew does not want to sit at the A seat.'),nl,
	write('<3> Carol wants to sit Andrew at his right side.'),nl,
	write('<4> Luke does not want to sit at both sides of Carol.'),nl,
	write('<5> Tommy does not want to sit at the E seat.'),nl,nl.

:- dlib_require(clp).

%%%%%%%%%%%%%%% Variable is Peaple %%%%%%%%%%%%%%%%%%%%%%
go:-
    demand,
    People =[Andrew,Carol,Jessica,Luke,Tommy],
    People in ['A','B','C','D','E'],
    alldifferent(People),
    Carol  in    ['C'],               % <1>   Carol sit seat='C'
    Andrew notin ['A'],               % <2>   Andrew does'nt sit seat='A'
    my_right_is(Carol, _ == Andrew),  % <3>   right side of Carol is Andrew
    my_right_is(Luke,  _ \== Carol),  % <4-1> right side of Luke is not Carol
    my_right_is(Carol, _ \== Luke),   % <4-2> left side of Luke is not Carol
    Tommy notin  ['E'],               % <5>   Tommy does'nt sit seat='E'
    labeling(People),
       sort([Andrew='Andrew',Carol='Carol',Jessica='Jessica',
             Luke='Luke',Tommy='Tommy'],Sorted),
       write(Sorted),nl,
    fail.

my_right_is(Me,Goal):- 
	arg(1,Goal,Right),arg(2,Goal,Who),
	freeze(Me,(s_right(Me,Right),freeze(Who,Goal))).

s_right('A','B'):-!.
s_right('B','C'):-!.
s_right('C','D'):-!.
s_right('D','E'):-!.
s_right('E','A').

%%%%%%%%%%%%%%%% Variable is Seat %%%%%%%%%%%%%%%%%%%%%
go_sv:-
    demand,
    Seat=[A,B,C,D,E],
    Round=[E|Seat],
    Seat in ['Andrew','Carol','Jessica','Luke','Tommy'],
    alldifferent(Seat),
    C in    ['Carol'],                       % <1>
    A notin ['Andrew'],                      % <2>
    right_is(Round,'Carol','Andrew', ==),    % <3>
    right_is(Round,'Luke', 'Carol' ,\==),    % <4-1>
    right_is(Round,'Carol','Luke'  ,\==),    % <4-2>
    E notin ['Tommy'],                       % <5>
    labeling(Seat),
       write(Seat),nl,
    fail.
 
right_is([A,B|L],Me,You,Func):- 
	!,freeze(A,(A==Me-> Goal=..[Func,B,You],freeze(B,Goal);true)),
	right_is([B|L],Me,You,Func).
right_is(_,_,_,_).
